<?php
/* SVN FILE: $Id: check.php 353 2008-05-11 22:57:53Z bb_yujiro $ */
/**
 * 実行処理
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends RKT_Controller
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!empty($_GET['complete'])){
            $this->assign('complete', true);
        }
        
        $this->_checkExtension();
        $this->_checkWritable();
    }

    /**
     * モジュールの確認
     *
     * @access private
     * @return void
     **/
    private function _checkExtension()
    {
        $ok = '<strong style="color:blue">enabled</strong>';
        $ng = '<strong style="color:red">disabled</strong>';

        $result = extension_loaded('pdo')?$ok:$ng;
        $this->assign('pdo', $result);

        $result = extension_loaded('pdo_mysql')?$ok:$ng;
        $this->assign('mysql', $result);

        $result = extension_loaded('pdo_pgsql')?$ok:$ng;
        $this->assign('pgsql', $result);

        $result = extension_loaded('pdo_sqlite')?$ok:$ng;
        $this->assign('sqlite', $result);

        $result = extension_loaded('gd')?$ok:$ng;
        $this->assign('gd', $result);

        $result = extension_loaded('mbstring')?$ok:$ng;
        $this->assign('mbstring', $result);

        $result = extension_loaded('gettext')?$ok:$ng;
        $this->assign('gettext', $result);

        $result = extension_loaded('zlib')?$ok:$ng;
        $this->assign('zlib', $result);

    }

    /**
     * ファイルの書き込み権限
     *
     * @access private
     * @return void
     **/
    private function _checkWritable()
    {
        $ok = '<strong style="color:blue">writable</strong>';
        $ng = '<strong style="color:red">not writable</strong>';

        $result = is_writable(BASE_DIR.'config.php')?$ok:$ng;
        $this->assign('config_php', $result);

        $result = is_writable(TMP_DIR)?$ok:$ng;
        $this->assign('tmp_dir', $result);

        $result = is_writable(ERROR_LOG_FILE)?$ok:$ng;
        $this->assign('error_log', $result);

        $result = is_writable(DB_DIR)?$ok:$ng;
        $this->assign('db_dir', $result);

        $result = is_writable(DB_DIR.'blob.db')?$ok:$ng;
        $this->assign('blob_db_file', $result);

        $result = is_writable(THEME_DIR)?$ok:$ng;
        $this->assign('theme_dir', $result);

        $result = is_writable(PLUGIN_DIR.'config.php')?$ok:$ng;
        $this->assign('plugin_php', $result);

        $result = is_writable(RESOURCE_DIR.'css'.DS.'common.css')?$ok:$ng;
        $this->assign('common_css', $result);
    }
} // Controller
?>