<?php
/* SVN FILE: $Id: admin.php 353 2008-05-11 22:57:53Z bb_yujiro $ */
/**
 * 実行処理
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rkt_session.php';
require LIB_DIR.'rkt_auth.php';

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends RKT_Controller
{
    /**
     * DB接続オジェクト
     * @var object
     */
    protected $_objdb = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->_objdb = RKT_DB::getInstance();
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!empty($_POST['manip']) && $this->objrqt->getValidate()){
            $this->updateAccount();

            $pram  = '?page=admin';
            $pram .= '&complete=1';
            header('Location: '.$_SERVER['PHP_SELF'].$pram);
        }

        if (!empty($_POST['manip'])){
            $this->assign('alert', $this->objrqt->getAlerts());
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true
            ),
            'password'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true
            ),
            'complete'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false
            ),
        );
    }

    /**
     * アカウント情報の更新
     *
     * @access private
     * @param array $value
     * @return integer  データ操作結果
     */
    public function updateAccount()
    {
        $now             = RKT_DB::now();
        $email           = RKT_crypt::getEncrypted($this->values['email']);
        $hashed_email    = RKT_crypt::getHashed($this->values['email']);
        $hashed_password = RKT_auth::getHashed($this->values['password']);
        
        $sql = 
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'modified = '.$now.','.
                'email = '.$this->_objdb->quote($email).','.
                'hashed_email = '.$this->_objdb->quote($hashed_email).','.
                'hashed_password = '.$this->_objdb->quote($hashed_password).' '.
            'WHERE '.
                'id = 1';
        return $this->_objdb->exec($sql);
    }

    /**
     * メール配信用雛形の更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    public function updateMailtpl()
    {
        $now = RKT_DB::now();
        $sql = 
            'UPDATE '.
                DB_PREFIX.'sys_mailtpl '.
            'SET '.
                'modified = '.$now.','.
                "email = '".WAP_ADMINISTRATOR."',".
                "name = '".WAP_SNS_NAME."' ".
            'WHERE '.
                'modified < '.$now;
        return $this->_objdb->exec($sql);
    }
} // Controller
?>