<?php
/* SVN FILE: $Id: trackback.php 163 2008-04-23 00:35:07Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'rev_trackback',
        ),
        'view'=> array(
        ),            
    );

    /**
     * rev_trackback モデルオブジェクト
     * @var object 
     */
    public $rev_trackback = null;

    /**
     * 商品コード
     * @var integer 
     */
    protected $item_code = null;

    /**
     * アクション
     * @var integer 
     */
    protected $action = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/blog.tpl');
        $this->rev_trackback->setValue('item_code', $this->item_code, RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $delete = true;
        if (empty($this->action)){
            $this->objvew->setBaseFile('common/frame/xml.tpl');
            $delete = false;
        }

        $this->_trackbackReceive();
        $this->objvew->assign('delete', $delete);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'item_code'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * トラックバックの受信
     *
     * @access public
     * @return void
     **/
    private function _trackbackReceive()
    {
        include LIB_DIR.'PEAR/Services/Trackback.php';

        // トラックバック情報
        $trackbackData = array(
            'id'            => $this->item_code,
            'host'          => $_SERVER['SERVER_ADDR'],
            'title'         => 'Review Trackback',
            'excerpt'       => 'Review Trackback',
            'url'           => HTTP_ACTION.'public/view/review/'.$this->item_code.'/',
            'blog_name'     => SNS_NAME,
            'trackback_url' => HTTP_ACTION.'public/trackback/review/'.$this->item_code.'/'
        );
        // Services_Trackbackオブジェクトの作成
        $objtb = Services_Trackback::create($trackbackData);
        if (PEAR::isError($objtb)) {
            $this->objvew->assign('error_code', 1);
            return ;
        }

        // 送信されたトラックバック情報を受信
        $result = $objtb->receive();
        if (PEAR::isError($result)) {
            $this->objvew->assign('error_code', 1);
            return ;
        }

        $url        = $objtb->get('url');
        $hashed_url = RKT_Crypt::getHashed($url);
        $excerpt    = $objtb->get('excerpt');
        
        $this->rev_trackback->title      = $objtb->get('title');
        $this->rev_trackback->excerpt    = mb_strimwidth($excerpt, 0, 200, '...');
        $this->rev_trackback->url        = $url;
        $this->rev_trackback->hashed_url = $hashed_url;
        $this->rev_trackback->blog_name  = $objtb->get('blog_name');
        $this->rev_trackback->ip_address = $objtb->get('host');
        
        $this->rev_trackback->manip();

        $this->objvew->assign('error_code', 0);
    }

} // class Controller
?>
