<?php
/* SVN FILE: $Id: login.php 618 2008-07-20 03:33:01Z bb_yujiro $ */
/**
 * ログイン
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 618 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-20 12:33:01 +0900 (日, 20 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * WebApplicationクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 618 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-20 12:33:01 +0900 (日, 20 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        /* シリアルIDによるログイン判定 */
        if (empty($_POST[Auth_AutoLogin::POST_SERIAL])){
            $this->_normalLogin();
        } else {
            $this->_SerialNumberLogin();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'autologin'=> array(
                'type'=>     'number',
                'option'=>   array('required'=> false),
            ),
        );
    }

    /**
     * 標準ログイン処理
     *
     * @access protected
     * @return string   絞込み句
     **/
    private function _normalLogin()
    {
        /* ログイン後のデフォルトジャンプ先 */
        $jumps = array(
            STATUS_ADMIN=>  HTTP_ACTION.'private/',
            STATUS_MEMBER=> HTTP_ACTION.'private/home/',
            STATUS_GUEST=>  HTTP_ACTION.'public/login/entrance/',
        );
        
        /* ログイン判定 */
        if (!RKT_Auth::exec()->logIn()){
            $email = empty($_POST['email'])? '':urlencode($_REQUEST['email']);
            $url   = HTTP_ACTION.'public/login/entrance/module/'.US.'mismatch=1&email='.$email;
            header('Location: '.$url);
            exit();
        }

        /* 自動ログイン設定 */
        if (!empty($_POST['autologin'])){
            Auth_AutoLogin::exec()->setAutoLogin();
        }
        
        /* ログイン後の表示URL設定 */
        $status = RKT_account::exec()->getStatus();
        $url    = $this->getHttpReferer(0);
        if (strpos($url, 'login')){
            $url = $jumps[$status];
        }

        header('Location: '. $this->_parsedURL($url));
        exit();
    }

    /**
     * シリアルナンバーログイン処理
     *
     * @access protected
     * @return string   絞込み句
     **/
    private function _SerialNumberLogin()
    {
        if (!Auth_AutoLogin::exec()->autoLogin()){
            $this->objvew->setContentFile('public'.DS.'login'.DS.'entrance.tpl');
            $request['mismatch'] = 1;
            $this->objvew->assign('request', $request);
        }
    }

    /**
     * URLのパース
     *
     * @access protected
     * @return string   絞込み句
     **/
    private function _parsedURL($url)
    {
        if (SID === ''){
            return $url;
        }

        $pos = strpos($url, '?');
        if ($pos === false){
            return $url.'?'.htmlspecialchars(SID, ENT_QUOTES);
        }

        return $url.'&'.htmlspecialchars(SID, ENT_QUOTES);
    }
} // class Controller
?>
