<?php
/* SVN FILE: $Id: account.php 538 2008-06-05 17:22:44Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 538 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-06 02:22:44 +0900 (金, 06 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 538 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-06 02:22:44 +0900 (金, 06 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller 
{
    /**
     * 招待ID
     * @var integer 
     */
    protected $id = 0;

    /**
     * キー
     * @var string 
     */
    protected $key = null;

    /**
     * 名
     * @var string 
     */
    protected $first_name = null;

    /**
     * 姓
     * @var string 
     */
    protected $last_name = null;

    /**
     * ニックネーム
     * @var string 
     */
    protected $nickname = null;

    /**
     * メールアドレス
     * @var string 
     */
    protected $email = null;

    /**
     * パスワード１
     * @var string 
     */
    protected $password = null;

    /**
     * パスワード２
     * @var string 
     */
    protected $verification = null;

    /**
     * メール送信フラグ
     * @var integer 
     */
    protected $mailing = null;

    /**
     * 規約の同意
     * @var integer 
     */
    protected $terms = null;

    /**
     * 招待元ID
     * @var integer 
     */
    private $_from = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_checkInvited();
        $this->_setMailings();
        $this->_checkPassword();

        $validated = $this->objrqt->getValidate();
        $action = array(
            'complete'=> false,
            'confirm'=> false,
            'goback'=> 'again'
        );

        /* 入力やり直し */
        if (!empty($_POST['again'])){
            $this->objvew->assign('request', $_SESSION['account']);
        }

        /* 新規登録 */
        if (!empty($_POST['manip'])){
            include LIB_DIR.'rktModel'.DS.'Manip.php';

            $this->_manipAccount();
            $this->_manipProfile();
            $this->_manipBlog();
            $this->_manipInvite();
            $this->_manipFriens();
            $this->_manipGadget();

            /* ログイン状態に */
            RKT_account::exec()->setAccount($this->ref_account);

            $action['complete'] = true;
            unset($_SESSION['account']);
        }

        /* 入力内容確認 */
        if (!empty($_POST['confirm'])){
            if ($validated){
                $action['confirm'] = true;
            }
            $this->objvew->assign('alert', $this->objrqt->getAlerts());
            $_SESSION['account'] = $this->objrqt->getRequests();
        }

        $this->objvew->assign('action', $action);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'key'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'first_name'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'last_name'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'nickname'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'password'=> array(
                'type'=>     'string',
                'option'=>   array(
                    'format'=> '\w+',
                    'min_length'=>4,
                    'max_length'=>16
                ),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'verification'=> array(
                'type'=>     'string',
                'option'=>   array(
                    'format'=> '\w+',
                    'min_length'=>4,
                    'max_length'=>16
                ),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'mailing'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'agree'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
        );
    }

    /**
     * URLのチェック
     *
     * @access private
     * @return void
     **/
    private function _checkInvited()
    {
        $condition = array(
            'id'=>         $this->id,
            'ref_friend'=> 0
        );
        $invite = RKT_DB::getRow('fri_invite', $condition);

        $this->email = RKT_Crypt::getDecrypted($invite['email']);
        $seed        = RKT_Crypt::getSeed($invite['ref_account']);
        $key         = RKT_Crypt::getKey($invite['email'], $seed);

        $this->objvew->assign('email', $this->email);
        
        if ($this->key != $key){
            $this->objvew->assign('is_invited', false);
        } else {
            $this->objvew->assign('is_invited', true);
        }
    }

    /**
     * メール受け取りの設定
     *
     * @access private
     * @return void
     **/
    private function _setMailings()
    {
        $type = array (
            STATUS_ENABLE => _('To receive mail'),
            STATUS_DISABLE=> _('Do not receive mail'),
        );
        $this->objvew->assign('mailings', $type);
    }

    /**
     * パスワードのチェック
     *
     * @access private
     * @return void
     **/
    private function _checkPassword()
    {
        if ($this->password != $this->verification){
            $this->objrqt->setAlert('unmatched');
        }
    }

    /**
     * アカウント
     *
     * @access private
     * @return void
     **/
    private function _manipAccount()
    {
        include MODEL_DIR.'manips'.DS.'act_account.php';

        $now = date('Y-m-d H:i:s');

        $objact = new act_account();

        $objact->setValue('last_login',      $now);
        $objact->setValue('regist_date',     $now);
        $objact->setValue('avail',           STATUS_ENABLE);
        $objact->setValue('status',          STATUS_MEMBER);
        $objact->setValue('email',           $this->email);
        $objact->setValue('hashed_password', $_SESSION['account']['password']);
        $objact->setValue('mailing',         $_SESSION['account']['mailing']);

        $objact->manip();
        
        $this->ref_account = $objact->getCurId();
    }

    /**
     * プロフィール
     *
     * @access private
     * @return void
     **/
    private function _manipProfile()
    {
        include MODEL_DIR.'manips'.DS.'act_profile.php';

        $objprf = new act_profile();

        $objprf->setValue('ref_account', $this->ref_account);
        $objprf->setValue('first_name',  $_SESSION['account']['first_name']);
        $objprf->setValue('last_name',   $_SESSION['account']['last_name']);
        $objprf->setValue('nickname',    $_SESSION['account']['nickname']);

        $objprf->manip();
    }

    /**
     * ブログ
     *
     * @access private
     * @return void
     **/
    private function _manipBlog()
    {
        include MODEL_DIR.'manips'.DS.'blg_blog.php';

        $objblg = new blg_blog();

        $objblg->setValue('ref_account', $this->ref_account);

        $objblg->manip();
    }

    /**
     * 招待
     *
     * @access private
     * @return void
     **/
    private function _manipInvite()
    {
        include MODEL_DIR.'manips'.DS.'fri_invite.php';

        $objivt = new fri_invite();

        $objivt->setCurId($this->id);
        $objivt->setInitValue();
        $objivt->setValue('ref_friend', $this->ref_account);

        $objivt->manip();
        
        $this->_from = $objivt->getValue('ref_account');
    }

    /**
     * 友達リスト
     *
     * @access private
     * @return void
     **/
    private function _manipFriens()
    {
        include MODEL_DIR.'manips'.DS.'fri_friends.php';

        $objfri = new fri_friends();

        $objfri->setValue('status',      STATUS_FRIEND_CONNECT);
        $objfri->setValue('ref_account', $this->_from);
        $objfri->setValue('ref_friend',  $this->ref_account);
        $objfri->setValue('comment',     '');
        $objfri->manip();

        $objfri->refreshColumn();
        $objfri->setValue('status',      STATUS_FRIEND_CONNECT);
        $objfri->setValue('ref_account', $this->ref_account);
        $objfri->setValue('ref_friend',  $this->_from);
        $objfri->setValue('comment',     '');
        $objfri->manip();
    }

    /**
     * ガジェット
     *
     * @access private
     * @return void
     **/
    private function _manipGadget()
    {
        include MODEL_DIR.'manips'.DS.'act_gadget.php';

        $objgad = new act_gadget();

        $objgad->setValue('ref_account', $this->ref_account);
        $objgad->setValue('title',       _('Blog'));
        $objgad->setValue('position',    POSITION_MIDDLE);
        $objgad->setValue('source',      HTTP_ACTION.'private/recent/blog/json/');
        $objgad->manip();

        $objgad->refreshColumn();
        $objgad->setValue('ref_account', $this->ref_account);
        $objgad->setValue('title',       _('Comment'));
        $objgad->setValue('position',    POSITION_MIDDLE);
        $objgad->setValue('source',      HTTP_ACTION.'private/recent/comment/json/');
        $objgad->manip();

        $objgad->refreshColumn();
        $objgad->setValue('ref_account', $this->ref_account);
        $objgad->setValue('title',       _('Topic'));
        $objgad->setValue('position',    POSITION_MIDDLE);
        $objgad->setValue('source',      HTTP_ACTION.'private/recent/topic/json/');
        $objgad->manip();

        $objgad->refreshColumn();
        $objgad->setValue('ref_account', $this->ref_account);
        $objgad->setValue('title',       _('Event'));
        $objgad->setValue('position',    POSITION_MIDDLE);
        $objgad->setValue('source',      HTTP_ACTION.'private/recent/event/json/');
        $objgad->manip();
    }
} // class Controller
?>
