<?php
/* SVN FILE: $Id: footprint.php 521 2008-05-30 16:18:52Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 521 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:18:52 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 521 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:18:52 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'log_footprint',
        ),            
    );

    /**
     * v_log_footprint モデルオブジェクト
     * @var object 
     */
    public $v_log_footprint = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->v_log_footprint->setValue('target',     RKT_access::TARGET_MEMBER);
        $this->v_log_footprint->setValue('ref_target', $this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        /* トータルアクセス数 */
        $condition = array(
            'target'=>     RKT_access::TARGET_MEMBER,
            'ref_target'=> $this->account['id'],
        );
        $result = RKT_DB::getRow('log_access', $condition, 'count(*) as ct');
        
        $total = empty($result['ct'])? 
                    $this->account['access_number']:
                    $this->account['access_number'] + $result['ct'];
        $this->objvew->assign('total', $total);
    }
} // class Controller
?>
