<?php
/* SVN FILE: $Id: theme.php 176 2008-04-24 11:31:08Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 176 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-24 20:31:08 +0900 (木, 24 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 176 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-24 20:31:08 +0900 (木, 24 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_account',
        ),
        'view'=> array(
            'des_theme',
        ),            
    );

    /**
     * act_profile モデルオブジェクト
     * @var object 
     */
    public $act_account = null;

    /**
     * des_theme モデルオブジェクト
     * @var object 
     */
    public $v_des_theme = null;

    /**
     * テーマID
     * @var integer
     */
    public $ref_theme = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->act_account->setCurId($this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!empty($this->ref_theme) && $this->checked_nonce){
            $this->act_account->setInitValue();
            $this->act_account->setUpdate();

            $this->act_account->setValue('ref_theme', $this->ref_theme);
            $this->act_account->manip();
            $this->objvew->assign('selected', true);
            Theme::Id($this->ref_theme);
            
            RKT_account::exec()->setAccount($this->account['id']);
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_theme'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
