<?php
/* SVN FILE: $Id: schedule.php 307 2008-05-09 22:53:36Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'cal_schedule',
        ),
        'view'=> array(
        ),            
    );

    /**
     * cal_schedule モデルオブジェクト
     * @var object 
     */
    public $cal_schedule = null;

    /**
     * timestamp
     * @var integer
     */
    public $timestamp = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->cal_schedule->setCurId($this->id);

        $this->cal_schedule->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setTimeList();

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_FRIEND=>    _('Friends'),
            VISIBILITY_HIDDEN=>    _('Just me'),
        );
        $this->objvew->assign('visibility', $visibility);

        $reminders = array(
            STATUS_DISABLE=> _('Do not send a reminder.'),
            STATUS_ENABLE=>  _('Send a reminder.'),
        );
        $this->objvew->assign('reminders', $reminders);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'timestamp'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    private function _setTimeList()
    {
        for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
            $hours[$num] = $num;
        }
        $sixty = array(
            '00'=>'00',
            '15'=>'15',
            '30'=>'30',
            '45'=>'45',
        );

        $this->objvew->assign('hours', $hours);
        $this->objvew->assign('sixty', $sixty);

        $this->timestamp = empty($this->timestamp)? time():$this->timestamp;
        $this->objvew->assign('date', date('Y-m-d', $this->timestamp));
    }
} // class Controller
?>
