<?php
/* SVN FILE: $Id: gadget.php 163 2008-04-23 00:35:07Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_gadget',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_gadget モデルオブジェクト
     * @var object 
     */
    public $act_gadget = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->act_gadget->setCurId($this->id);
        $this->act_gadget->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->checked_nonce){
            $this->_updateGadgets();
            $this->_updateDisplay();
        }

        $positions = array(
            POSITION_MIDDLE=> _('Living'),
            POSITION_RIGHT=>  _('Side'),
        );
        $this->objvew->assign('positions', $positions);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'updates'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'display'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 更新リストの処理
     *
     * @access private
     * @return void
     **/
    private function _updateGadgets()
    {
        if (empty($_POST['manips'])){
            return ;
        }
        if (empty($this->updates)){
            return ;
        }
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        $result = false;
        
        $data = '';
        foreach ($this->updates as $key=>$sort){
            $id = substr($key, 7);
            if (is_numeric($id) && is_numeric($sort)){
                $this->act_gadget->setCurId($id);
                $this->act_gadget->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
                $this->act_gadget->setValue('sort', $sort);

                $this->act_gadget->setInitValue();
                $this->act_gadget->setUpdate();
                $result = $this->act_gadget->manip();
                
                $this->act_gadget->refreshColumn();
            }
        } // foreach ($this->updates as $key=>$sort)

        $this->objvew->assign('data', $result);
    }


    /**
     * 表示設定の更新処理
     *
     * @access private
     * @return void
     **/
    private function _updateDisplay()
    {
        if (empty($_POST['update'])){
            return ;
        }
        if ($this->display < 0){
            return ;
        }
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->act_gadget->setUpdate();
        $this->act_gadget->setValue('display', $this->display);
        $result = $this->act_gadget->manip();

        $this->objvew->assign('data', $result);
    }
} // class Controller
?>
