<?php
/* SVN FILE: $Id: profile.php 163 2008-04-23 00:35:07Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_profile',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_profile モデルオブジェクト
     * @var object 
     */
    public $act_profile = null;

    /**
     * act_personality モデルオブジェクト
     * @var object 
     */
    public $act_personality = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->act_profile->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);

        include MODEL_DIR.'manips'.DS.'act_personality.php';        
        $this->act_personality = new act_personality();
        $this->act_personality->setValue('ref_account', $this->account['id']);

        $this->_setItem();
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setRichEditor();
        $this->objvew->addJavas('js/city.js');

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_FRIEND=>    _('Friends'),
            VISIBILITY_HIDDEN=>    _('Just me'),
        );
        $this->objvew->assign('visibility', $visibility);

        if ($this->checked_nonce){
            $this->act_personality->manipPersonalities();
        }
        
        $this->_setCity('ref_region',   'cities');
        $this->_setCity('ref_hometown', 'homecities');        
    }

    /**
     * 市区町村の設定
     *
     * @access private
     * @param string $key
     * @param string $askey
     * @return void
     */
    private function _setCity($key, $askey)
    {
        $ref_region = $this->act_profile->getValue($key);
        $condition = array(
            'ref_region'=> $ref_region
        );
        $list = $this->act_profile->getReferenceList('ara_city', $order='sort', $condition);

        $this->objvew->assign($askey, $list);
    }

    /**
     * 追加項目の設定
     *
     * @access private
     * @return void
     */
    private function _setItem()
    {
        $list = $this->act_personality->getPersonality();
        $this->objvew->assign('items', $list);
    }
} // class Controller
?>
