<?php
/* SVN FILE: $Id: upload.php 385 2008-05-15 02:43:17Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_attach',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_attach モデルオブジェクト
     * @var object 
     */
    public $act_attach = null;

    /**
     * URL引数
     * @var string 
     */
    protected $param = null;

    /**
     * アルバムId
     * @var integer
     */
    protected $ref_album = null;

    /**
     * 反映
     * @var integer
     */
    protected $reflect = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->act_attach->setValue('ref_account', $this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->param == 'module'){
            $this->_module();
        } else {
            $this->_setHTML();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'param'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'ref_album'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'reflect'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * モジュール処理
     *
     * @access private
     * @return void
     **/
    private function _module()
    {
        $this->objvew->setBaseFile('common/frame/xml.tpl');

        $id   = null;
        $name = null;
        if (!empty($_POST['manip']) && $this->checked_nonce){
            $this->act_attach->catchFile('attach');
            if ($this->act_attach->manip()){
                $id   = $this->act_attach->getCurId();
                $name = $this->act_attach->thumbnail;
            }
        }
        $this->objvew->assign('id',   $id);
        $this->objvew->assign('name', $name);

        $this->objvew->assign('isModule', true);
    }

    /**
     * 一般ページ処理
     *
     * @access private
     * @return void
     **/
    private function _setHTML()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/album.tpl');

        if ($this->checked_nonce){
            if (!empty($_POST['manip'])){
                $this->act_attach->setValue('ref_album', $this->ref_album);

                $this->act_attach->catchFile('attach');
                if ($this->act_attach->manip()){
                    $this->objvew->assign('name',   $this->act_attach->thumbnail);
                    $this->objvew->assign('width',  $this->act_attach->t_width);
                    $this->objvew->assign('height', $this->act_attach->t_height);
                }
            } elseif (!empty($this->reflect)) {
                /* メールからの添付ファイルインポート */
                include LIB_DIR.'rktBlob/Attach.php';

                BLOB_Attach::exec()->execute();                
            }
        } // if ($this->checked_nonce)

        $this->objvew->assign('isModule', false);
        
        $this->_setAlbum();
    }

    /**
     * アルバムリストの設定
     *
     * @access private
     * @return void
     **/
    private function _setAlbum()
    {
        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $albums = RKT_DB::getList('act_album', $condition);

        $reference = array();
        foreach ($albums as $row){
            $reference[$row['id']] = $row['album'];
        }

        $this->objvew->assign('albums', $albums);
        $this->objvew->assign('act_album', $reference);
    }
} // class Controller
?>
