<?php
/* SVN FILE: $Id: list.php 443 2008-05-20 08:53:37Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 443 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:37 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 443 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:37 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_attach',
        ),
        'view'=> array(
            'act_attach',
        ),            
    );

    /**
     * act_attach モデルオブジェクト
     * @var object 
     */
    public $act_attach = null;

    /**
     * v_act_attach モデルオブジェクト
     * @var object 
     */
    public $v_act_attach = null;

    /**
     * URL引数
     * @var string 
     */
    protected $param = null;

    /**
     * アルバムID
     * @var integer 
     */
    protected $ref_album = null;

    /**
     * 選択ファイル
     * @var string 
     */
    protected $selected = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->v_act_attach->setValue('ref_account', $this->account['id']);
        $this->v_act_attach->setLimit(LIMIT_TILE);
        $this->v_act_attach->setOrder('modified DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->param == 'json'){
            $this->_setJson();
        } else {
            $this->_listAttach();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'param'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'ref_album'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'selected'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 添付ファイルストの設定
     *
     * @access private
     * @return void
     **/
    private function _listAttach()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/album.tpl');
        if ($this->ref_album != ''){
            $this->v_act_attach->setValue('ref_album', $this->ref_album);
        }

        $this->_updateAttach();
        $this->_deleteAttach();

        if (!empty($this->ref_album)){
            $condition = array(
                'id'=>          $this->ref_album,
                'ref_account'=> $this->account['id']
            );
            $album = RKT_DB::getRow('act_album', $condition);

            $this->objvew->assign('album', $album);
        }

        $this->_setAlbum();

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_FRIEND=>    _('Friends'),
            VISIBILITY_HIDDEN=>    _('Just me'),
        );
        $this->objvew->assign('visibility', $visibility);
    }

    /**
     * アルバムリストの設定
     *
     * @access private
     * @return void
     **/
    private function _setAlbum()
    {
        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $albums = RKT_DB::getList('act_album', $condition);

        $reference = array();
        foreach ($albums as $row){
            $reference[$row['id']] = $row['album'];
        }

        $this->objvew->assign('albums', $albums);
        $this->objvew->assign('act_album', $reference);
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->v_act_attach->setLimit(LIMIT_JSON_ATTACH);
        $attaches = $this->v_act_attach->getValues();

        $this->objvew->assign('data', json_encode($attaches));
    }

    /**
     * 添付ファイルの更新
     *
     * @access private
     * @return void
     **/
    private function _updateAttach()
    {
        if (empty($_POST['manips'])){
            return ;
        }
        if (empty($this->selected)){
            return ;
        }

        foreach ($this->selected as $id){
            $this->act_attach->setCurId($id);
            $this->act_attach->setInitValue();

            $this->act_attach->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
            $this->act_attach->setValue('ref_album',   $this->ref_album);
            $this->act_attach->setUpdate();

            $this->act_attach->manip();
            $this->act_attach->refreshColumn();
        }
    }

    /**
     * 添付ファイルの削除
     *
     * @access private
     * @return void
     **/
    private function _deleteAttach()
    {
        if (empty($_POST['delete'])){
            return ;
        }
        if (empty($this->selected)){
            return ;
        }

        $this->act_attach->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);

        foreach ($this->selected as $id){
            $this->act_attach->setCurId($id);
            $this->act_attach->setDelete();

            $this->act_attach->manip();
        }
    }
} // class Controller
?>
