<?php
/* SVN FILE: $Id: album.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    var $models = array(
        'manip'=> array(
            'act_album',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_album モデルオブジェクト
     * @var object 
     */
    var $act_album = null;


    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/album.tpl');

        $this->act_album->setCurId($this->id);
        $this->act_album->setValue('ref_account', $this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function action()
    {
        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_FRIEND=>    _('Friends'),
            VISIBILITY_HIDDEN=>    _('Just me'),
        );
        $this->objvew->assign('visibility', $visibility);

        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $albums = RKT_DB::getList('act_album', $condition);
        $this->objvew->assign('albums', $albums);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
