<?php
/* SVN FILE: $Id: plugin.php 552 2008-06-07 04:16:32Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 552 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-07 13:16:32 +0900 (土, 07 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 552 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-07 13:16:32 +0900 (土, 07 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Plugin_Controller extends RKT_Controller
{
    /**
     * プラグインクラス名
     * @var array
     */
    protected $plugins = null;

    /**
     * ベンダー名
     * @var string
     */
    protected $_vendor = null;

    /**
     * モジュール名
     * @var string
     */
    protected $_module = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $vendor
     * @param string $content_tpl
     * @return void
     */
    public function __construct ($vendor, $module)
    {
        $this->objdb  = RKT_DB::getInstance();
        $this->objrqt = RKT_Request::getInstance();
        $this->objvew = RKT_View::getInstance();
        $this->objmdl = new RKT_Model();

        $this->_vendor = $vendor;
        $this->_module = $module;
        $page          = $this->objrqt->getRequest('page');


        $this->objvew->setDir(PLUGIN_DIR);
        $this->objvew->setPluginContentFile($vendor.DS.$module.DS.'views'.DS, $page.'.tpl');
        $this->objvew->setDir(VIEW_DIR);

        $this->initGrouping();
        $this->setNonce();
        $this->_setModels();
        $this->setRequest();
        $this->initValue();
        $this->_initModelValue();

        $general = array(
            STATUS_ADMIN=>  'common/menuBar/general.tpl',
            STATUS_GUEST=>  'common/menuBar/guest.tpl',
            STATUS_MEMBER=> 'common/menuBar/general.tpl',
        );
        $this->objvew->setTemplate('generalbar_tpl', $general[$this->account['status']]);
    }

    /**
     * コントローラの読み込み
     *
     * @access public
     * @return object
     **/
    public function &getController($group, $vendor, $module)
    {
        /* パスインフォからIDを取得 */
        $objrqt = RKT_Request::getInstance();
        $condition = array(
            'type'=>     'string',
            'option'=>   array(),            
            'required'=> false,
            'pic_up'=>   'PathArgs'
        );
        if ($objrqt->catchValidate('page', $condition)){
            $page = $objrqt->getRequest('page');
        }

        if (!file_exists(PLUGIN_DIR.$vendor.DS.$module.DS.'controllers'.DS.$page.'.php')){
            include CONTROLLER_DIR.'public.php';
            include CONTROLLER_DIR.'public'.DS.'content'.DS.'cover.php';

            $objController = new Controller('public'.DS.'content'.DS.'cover.tpl');
            return $objController;
        }
        include PLUGIN_DIR.$vendor.DS.$module.DS.'controllers'.DS.$page.'.php';
        
        $objController = new Controller($vendor, $module);
        return $objController;
    }

    /**
     * グループ毎の初期化
     *
     * @access protected
     * @return void
     **/
    protected function initGrouping()
    {
        $this->account = RKT_account::exec()->getAccount();

        /* 会員判定 */
        if ($this->account['status'] == STATUS_GUEST){
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/public.tpl');
            $this->objvew->setTemplate('sidebar_tpl', 'common/menu/login.tpl');
        } else {
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
            $this->objvew->addCss('css/private.css');
            $this->objvew->setTemplate('sidebar_tpl', 'common/menu/profile.tpl');
        }
        
        $this->visible = VISIBILITY_HIDDEN;
        $this->visible |= VISIBILITY_PUBLIC;
        $this->visible |= VISIBILITY_PROTECTED;
        $this->visible |= VISIBILITY_FRIEND;
        $this->visible |= VISIBILITY_PRIVATE;
        
        $this->objvew->baseAssign('account', $this->account);
        $this->objvew->baseAssign('member',  $this->account);
        $this->objvew->baseAssign('visible', $this->visible);

        Theme::Id($this->account['ref_theme']);

        /* アクセスログ */
        RKT_access::exec()->access(RKT_access::TARGET_PUBLIC, 
                        $this->account['id'], $this->account['id']);
    }

    /**
     * Modelオブジェクトの設定
     *
     * @access private
     * @return void
     */
    private function _setModels()
    {
        if (empty($this->models)){
            return ;
        }
        $references = array();

        /* Model_Manipオブジェクトの生成 */
        if (count($this->models['manip'])){
            include LIB_DIR.'rktModel'.DS.'Manip.php';
            foreach ($this->models['manip'] as $class){
                include PLUGIN_DIR.$this->_vendor.DS.$this->_module.DS.'models'.DS.'manips'.DS.$class.'.php';
                $this->$class = new $class();
                $reference = $this->$class->getReference();
                foreach ($reference as $table){
                    $references[$table] = $table;
                }
            } // foreach ($this->models['manip'] as $model)
        }

        /* Model_Viewオブジェクトの生成 */
        if (count($this->models['view'])){
            include LIB_DIR.'rktModel'.DS.'View.php';
            foreach ($this->models['view'] as $table){
                include PLUGIN_DIR.$this->_vendor.DS.$this->_module.DS.'models'.DS.'views'.DS.$table.'.php';
                $objname = 'v_'.$table;
                $class   = 'View_'.$table;

                $this->$objname = new $class();
                $reference = $this->$objname->getReference();
                foreach ($reference as $table){
                    $references[$table] = $table;
                }
            } // foreach ($this->models['view'] as $model)
        }

        $reference = array();
        foreach ($references as $table){
            $reference[$table] = $this->objmdl->getReferenceList($table);
        }
        $this->objvew->assign('reference', $reference);
    }

    /**
     * Model初期データの設定
     *
     * @access private
     * @return void
     */
    private function _initModelValue()
    {
        if (empty($this->models)){
            return ;
        }
        $request = '_POST';
        if (isSet($_POST['again']) || isSet($_POST['manip'])){
            $request = '_SESSION';
        }

        $self  = getUrlSelf();
        $catch = false;
        if ($pos = strpos($self, 'manip')){
            $catch = true;
        } elseif ($pos = strpos($self, 'confirm')){
            $catch = true;
        } elseif (array_key_exists('again', $_POST)){
            $catch = true;
        } elseif (array_key_exists('attach', $_POST)){
            $catch = true;
        } elseif (array_key_exists('confirm', $_POST)){
            $catch = true;
        } elseif (array_key_exists('manip', $_POST)){
            $catch = true;
        }

        /* Model_Manipオブジェクトの生成 */
        if (count($this->models['manip'])){
            foreach ($this->models['manip'] as $class){
                $this->$class->setInitValue();
            } // foreach ($this->models['manip'] as $model)

            if ($catch){
                foreach ($this->models['manip'] as $class){
                    $this->$class->catchRequest($request);
                } // foreach ($this->models['manip'] as $model)
            }
        }

        /* Model_Viewオブジェクトの生成 */
        if (count($this->models['view'])){
            foreach ($this->models['view'] as $table){
                $objname = 'v_'.$table;
                $this->$objname->catchRequest();

                $this->objvew->assign('r_'.$table, $this->$objname->requests);
            } // foreach ($this->models['view'] as $model)
        }
    }
} // class Controller
?>
