<?php
/* SVN FILE: $Id: comments.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'cal_comment',
        ),            
    );

    /**
     * cal_comment モデルオブジェクト
     * @var object 
     */
    public $v_cal_comment = null;

    /**
     * スケジュールID
     * @var integer
     */
    protected $ref_schedule = null;

    /**
     * サマリーアクション
     * @var string
     */
    protected $summary = null;

    /**
     * サマリーリスト
     * @var array
     */
    private $_list = array();

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/blog.tpl');

        $this->v_cal_comment->setValue('ref_account', $this->member['id']);
        if (!empty($this->ref_schedule)){
            $this->v_cal_comment->setValue('ref_schedule', $this->ref_schedule);
        }

        $this->v_cal_comment->setOrder('regist_date DESC');
        $this->v_cal_comment->setLimit(LIMIT_BLOG);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $command = '';
        if (!empty($this->ref_schedule)){
            $schedule = RKT_DB::getRow('cal_schedule', $this->ref_schedule);
            $this->objvew->assign('schedule', $schedule);
        } else {
            $command  = '<a href="'.HTTP_ACTION.'member/schedule/view/%s/">';
            $command .= '<img src="'.BASE_URL.'resource/img/icons/date.gif"';
            $command .= ' width="16" height="16" alt="&gt;"/>'._('View Schedule').'</a><br>';
        }
        $this->objvew->assign('command', $command);
        $this->_setSummary();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_schedule'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'summary'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * Summaryデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setSummary()
    {
        if (empty($this->summary)){
            return ;
        }

        $result = $this->v_cal_comment->getValues();
        foreach ($result as $row){
            /* スケジュール */
            $schedule = RKT_DB::getRow('cal_schedule', $row['ref_schedule'], 'subject');

            /* プロフィール */
            $condition = array(
                'ref_account'=> $row['ref_author']
            );
            $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

            $this->_list[] = array(
                'title'=>       $schedule['subject'],
                'link'=>        HTTP_ACTION.'member/blog/view/'.$row['ref_schedule'].'/#Comments',
                'modified'=>    $row['modified'],
                'date'=>        fDate($row['modified'], _('Y-m-d')),
                'creator'=>     $profile['nickname'],
                'description'=> strip_tags($row['comment']),
            );
        }
        
        if ($this->summary == 'json'){
            $this->_setJson();
        } else {
            $this->_setXml();
        }
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->objvew->assign('data', json_encode($this->_list));
    }

    /**
     * XMLデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setXml()
    {
        if ($this->summary == 'rss'){
            $this->objvew->setBaseFile('common/summary/rss.tpl');
        } elseif ($this->summary == 'atom') {
            $this->objvew->setBaseFile('common/summary/atom.tpl');
        } elseif ($this->summary == 'rdf') {
            $this->objvew->setBaseFile('common/summary/rdf.tpl');
        } else {
            return ;
        }
        $this->objvew->setMimeType('text/xml');
        $modified = empty($this->_list[0]['modified'])? 'now':$this->_list[0]['modified'];

        /* プロフィール */
        $condition = array(
            'ref_account'=> $this->member['id']
        );
        $profile = RKT_DB::getRow('act_profile', $condition, 'nickname,comment');

        $summary = array(
            'title'=>       sprintf(_("%s's Blog"), $profile['nickname']),
            'link'=>        HTTP_ACTION.'member/blog/list/'.$this->member['id'].'/',
            'modified'=>    $modified,
            'creator'=>     $profile['nickname'],
            'description'=> strip_tags($profile['comment']),
            'list'=>        $this->_list
        );

        $this->objvew->assign('summary', $summary);
    }
} // class Controller
?>
