<?php
/* SVN FILE: $Id: calendar.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'cal_schedule',
        ),            
    );

    /**
     * cal_schedule モデルオブジェクト
     * @var object 
     */
    public $v_cal_schedule = null;

    /**
     * タイムスタンプ
     * @var integer
     */
    protected $timestamp = null;

    /**
     * 予定
     * @var array
     */
    private $_schedule = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->timestamp = empty($this->timestamp)? strtotime(date('Y-m-01')):$this->timestamp;
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setAddSchedule();
        $this->_setSchedule();
        $this->objvew->assign('schedule', $this->_schedule);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'timestamp'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 編集リンクの作成
     *
     * @access public
     * @return void
     **/
    private function _setAddSchedule()
    {
        $now   = strtotime(date('Y-m-01'));
        $start = 1;

        if ($this->timestamp < $now){
            return ;
        } elseif ($this->timestamp == $now){
            $start = date('d');
        }
                
        for ($day=$start; $day<=31; $day++){
            $days = strtotime(($day-1).' day', $this->timestamp);
            $href = HTTP_ACTION.'private/post/schedule/0/'.$days.'/';
            $anc  = '<a href="'.$href.'">';
            $anc .= '<img src="'.BASE_URL.'resource/img/icons/date_edit.gif" width="16" height="16" align="absbottom" />';
            $anc .= '</a>';
            
            $this->_schedule[$day][] = $anc;
        }
    }

    /**
     * スケジュールリストの設定
     *
     * @access private
     * @return void
     **/
    private function _setSchedule()
    {
        $start_date = date('Y-m-01', $this->timestamp);
        $last_date  = date('Y-m-t',  $this->timestamp);

        $n_start_time = strtotime($start_date);
        $n_last_time  = strtotime($last_date);

        $condition = array(
            'ref_account'=> $this->member['id'],
            'start_date'=>  array('<=', $last_date),
            'end_date'=>    array('>=', $start_date),
            'visibility'=>  array('&', $this->visible)
        );
        $list = RKT_DB::getList('cal_schedule', $condition, 'id,schedule,start_date,end_date');

        $img = '<img src="'.BASE_URL.'resource/img/icons/information.gif" width="16" height="16" align="absmiddle" alt="&gt;" />';
        foreach ($list as $row){
            $start_time = strtotime($row['start_date']);
            $end_time   = strtotime($row['end_date']);

            $offset = ($start_time >= $n_start_time)? date('j', $start_time):1;
            $limit  = ($end_time   <= $n_last_time) ? date('j', $end_time):31;

            $href  = HTTP_ACTION.'member/schedule/view/'.$row['id'].'/';
            $label = mb_strimwidth($row['schedule'], 0, 20, '...');

            for ($day=$offset; $day<=$limit; $day++){
                $anc  = '<br />';
                $anc .= '<a href="'.$href.'" title="'.$row['schedule'].'">';
                $anc .= $img.'</a>';
                $anc .= '<a href="'.$href.'" title="'.$row['schedule'].'">';
                $anc .= $label.'</a>';

                $this->_schedule[$day][] = $anc;
            }
        }
    }
} // class Controller
?>
