<?php
/* SVN FILE: $Id: view.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
        ),            
    );

    /**
     * sum_answer モデルオブジェクト
     * @var object 
     */
    public $v_sum_answer = null;

    /**
     * アンケート(Member_Controllerで取得)
     * @var array
     */
    protected $poll = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setRichEditor();
        $this->objvew->addJavas('yui/datasource/datasource-beta-min.js');
        $this->objvew->addJavas('yui/charts/charts-experimental-min.js');

        $this->objvew->assign('poll', $this->poll);
        $this->_setAnswer();
    }

    /**
     * 解答用入力欄設定
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _setAnswer()
    {
        $answers = explode("\r\n", $this->poll['answers']);
        $this->objvew->assign('answers', $answers);
        
        $datas = array();
        foreach ($answers as $id=>$answer){
            $condition = array(
                'ref_poll'=> $this->poll['id'],
                'answer'=>       $id,
            );
            $count = RKT_DB::getRow('sum_answer', $condition, 'count(*) as ct');

            $datas[$id] = array(
                'response'=> $answer,
                'count'=>    $count['ct'],
            );
        }
        $this->objvew->assign('datas', $datas);
    }
} // class Controller
?>
