<?php
/* SVN FILE: $Id: answer.php 307 2008-05-09 22:53:36Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'sum_answer',
        ),
        'view'=> array(
        ),            
    );

    /**
     * sum_answer モデルオブジェクト
     * @var object 
     */
    public $sum_answer = null;

    /**
     * 回答ID
     * @var integer
     */
    protected $ref_answer = null;

    /**
     * アンケート(Member_Controllerで取得)
     * @var array
     */
    protected $poll = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->sum_answer->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
        $this->sum_answer->setValue('ref_poll',    $this->id, RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->account['status'] == STATUS_GUEST){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        if ($this->checked_nonce){
            $this->sum_answer->manip();
        } // if ($this->checked_nonce)

        $this->objvew->assign('poll', $this->poll);
        $this->_setAnswer();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_answer'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }

    /**
     * 解答用入力欄設定
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _setAnswer()
    {
        $answers = explode("\r\n", $this->poll['answers']);
        $this->objvew->assign('answers', $answers);
    }
} // class Controller
?>
