<?php
/* SVN FILE: $Id: search.php 397 2008-05-16 08:25:16Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 397 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-16 17:25:16 +0900 (金, 16 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 397 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-16 17:25:16 +0900 (金, 16 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'act_profile',
        ),            
    );

    /**
     * act_profile モデルオブジェクト
     * @var object 
     */
    public $v_act_profile = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/search.tpl');
        // $this->v_act_profile->setOrder('modified DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->addJavas('js/city.js');

        $this->_setCity('ref_region',   'cities');
        $this->_setCity('ref_hometown', 'homecities');

        $this->objvew->assign('order_label', $this->v_act_profile->getOrderLabel());
    }

    /**
     * 市区町村の設定
     *
     * @abstract
     * @access protected
     * @param string $key
     * @param string $askey
     * @return void
     */
    private function _setCity($key, $askey)
    {
        $ref_region = $this->v_act_profile->getValue($key);
        $condition = array(
            'ref_region'=> $ref_region
        );
        $list = $this->v_act_profile->getReferenceList('ara_city', $order='sort', $condition);

        $this->objvew->assign($askey, $list);
    }
} // class Controller
?>
