<?php
/* SVN FILE: $Id: friends.php 474 2008-05-22 09:38:43Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 474 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:38:43 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 474 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:38:43 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'fri_friends',
        ),            
    );

    /**
     * v_fri_friends モデルオブジェクト
     * @var object 
     */
    public $v_fri_friends = null;

    /**
     * JSON指定
     * @var string 
     */
    protected $json = null;

    /**
     * ステータス
     * @var integer 
     */
    protected $status = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $status = empty($this->status)? STATUS_FRIEND_CONNECT:$this->status;
        if ($this->member['id'] != $this->account['id']){
            $status = STATUS_FRIEND_CONNECT;
        }

        $this->v_fri_friends->setValue('ref_account', $this->member['id']);
        $this->v_fri_friends->setValue('status',      $status);

        $this->v_fri_friends->setLimit(LIMIT_TILE);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setCommand();
        $this->_setJson();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'json'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }

    /**
     * コマンドの設定
     *
     * @access private
     * @return void
     **/
    private function _setCommand()
    {
        if ($this->member['id'] != $this->account['id']){
            $this->objvew->assign('command', '');
            return ;
        }
        $nonce = RKT_Crypt::getNonce('manipNonce');

        $command = '';
        if ($this->status == STATUS_FRIEND_CONNECT){
            /* 友達にコメントを送る */
            $command  = '&nbsp;<a href="'.HTTP_ACTION.'member/contact/'.
                        'comment/%s/"><img src="'.BASE_URL.'resource/img/icons/user_comment.gif"'.
                        ' width="16" height="16" alt="'._('Post Comment').'" /></a>&nbsp;';

            /* 友達名簿から削除する */
            $command .= '&nbsp;<a href="'.HTTP_ACTION.'private/personal/'.
                        'friends/%s/delete/'.US.'_mpnnc='.$nonce.'"><img src="'.BASE_URL.'resource/img/icons/user_cancel.gif"'.
                        ' width="16" height="16" alt="'._('Delete Friends').'" /></a>&nbsp;';
        } elseif ($this->status == STATUS_FRIEND_CHATCH) {
            /* 友達リストに加える */
            $command  = '&nbsp;<a name="%s" href="'.HTTP_ACTION.'private/personal/'.
                        'friends/%s/confirm/'.US.'_mpnnc='.$nonce.'"><img src="'.BASE_URL.'resource/img/icons/user_add.gif"'.
                        ' width="16" height="16" alt="'._('Add Friends').'" /></a>&nbsp;';

            /* 友達名簿から削除する */
            $command .= '&nbsp;<a href="'.HTTP_ACTION.'private/personal/'.
                        'friends/%s/delete/'.US.'_mpnnc='.$nonce.'"><img src="'.BASE_URL.'resource/img/icons/user_cancel.gif"'.
                        ' width="16" height="16" alt="'._('Delete Friends').'" /></a>&nbsp;';
        }

        $this->objvew->assign('command', $command);
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        if ($this->json != 'json'){
            return ;
        }
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');

        $this->v_fri_friends->setLimit(LIMIT_JSON_FRIENDS);
        $this->v_fri_friends->setField('ref_friend');
        $friends = $this->v_fri_friends->getValues();

        $list = array();
        foreach ($friends as $row){
            /* プロフィール */
            $condition = array(
                'ref_account'=> $row['ref_friend']
            );
            $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

            /* 画像情報の読み込み */
            $condition = array(
                'status'=>      STATUS_PHOTO_MAIN,
                'ref_account'=> $row['ref_friend']
            );
            $photo  = RKT_DB::getRow('act_photo', $condition);

            $list[] = array(
                'id'=>       $row['ref_friend'],
                'name'=>     $profile['nickname'],
                'nickname'=> $profile['nickname'],
                'src'=>      empty($photo['thumbnail'])? NOPHOTO_SMALL:$photo['thumbnail'],
                'width'=>    empty($photo['t_width'])?   PHOTO_SMALL_SIZE:$photo['t_width'],
                'height'=>   empty($photo['t_height'])?  PHOTO_SMALL_SIZE:$photo['t_height'],
            );
        }

        $this->objvew->assign('data', json_encode($list));
    }
} // class Controller
?>
