<?php
/* SVN FILE: $Id: comment.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'fri_comment',
        ),            
    );

    /**
     * v_fri_comment モデルオブジェクト
     * @var object 
     */
    public $v_fri_comment = null;

    /**
     * JSON指定
     * @var string 
     */
    protected $param = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->v_fri_comment->setValue('ref_account', $this->member['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->param == 'json'){
            $this->_setJson();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'param'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->v_fri_comment->setLimit(LIMIT_JSON_FRIENDS);
        $this->v_fri_comment->setField('ref_friend,comment');
        $friends = $this->v_fri_comment->getValues();
        
        $list = array();
        foreach ($friends as $row){
            /* プロフィール */
            $condition = array(
                'ref_account'=> $row['ref_friend']
            );
            $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

            /* 画像情報の読み込み */
            $condition = array(
                'status'=>      STATUS_PHOTO_MAIN,
                'ref_account'=> $row['ref_friend']
            );
            $photo  = RKT_DB::getRow('act_photo', $condition);

            $list[] = array(
                'id'=>       $row['ref_friend'],
                'nickname'=> $profile['nickname'],
                'src'=>      empty($photo['thumbnail'])? NOPHOTO_SMALL:$photo['thumbnail'],
                'width'=>    empty($photo['t_width'])?   PHOTO_SMALL_SIZE:$photo['t_width'],
                'height'=>   empty($photo['t_height'])?  PHOTO_SMALL_SIZE:$photo['t_height'],
                'comment'=>  $row['comment'],
            );
        }

        $this->objvew->assign('data', json_encode($list));
    }
} // class Controller
?>
