<?php
/* SVN FILE: $Id: album.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'act_attach',
        ),            
    );

    /**
     * v_act_attach モデルオブジェクト
     * @var object 
     */
    public $v_act_attach = null;

    /**
     * AlbumID
     * @var integer 
     */
    protected $ref_album = null;

    /**
     * URL引数
     * @var string 
     */
    protected $param = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/album.tpl');

        $this->v_act_attach->setValue('ref_account', $this->member['id']);
        $this->v_act_attach->setLimit(LIMIT_TILE);
        $this->v_act_attach->setOrder('modified DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setAlbum();

        $this->v_act_attach->setValue('ref_album', $this->ref_album);

        if ($this->param == 'json'){
            $this->_setJson();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_album'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'param'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * アルバムの設定
     *
     * @access private
     * @return void
     **/
    private function _setAlbum()
    {
        $condition = array(
            'ref_account'=> $this->member['id'],
            'visibility'=>  array('&', $this->visible)
        );
        $result = RKT_DB::getList('act_album', $condition);
        if (empty($result[0]['id'])){
            $this->objvew->assign('albums', array());
            return ;
        }
        $ref_album = $result[0]['id'];
        
        $albums = array();
        foreach ($result as $row){
            $albums[$row['id']] = $row;
        }

        if (empty($albums[$this->ref_album])){
            $album = $albums[$ref_album];
            $this->ref_album = $ref_album;
        } else {
            $album = $albums[$this->ref_album];
        }

        $this->objvew->assign('album',  $album);
        $this->objvew->assign('albums', $albums);
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        if (empty($this->ref_album)){
            return ;
        }
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->v_act_attach->setLimit(LIMIT_JSON_ATTACH);
        $attaches = $this->v_act_attach->getValues();

        $this->objvew->assign('data', json_encode($attaches));
    }
} // class Controller
?>
