<?php
/* SVN FILE: $Id: member.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'com_names',
        ),            
    );

    /**
     * com_names モデルオブジェクト
     * @var object 
     */
    public $v_com_names = null;

    /**
     * JSON指定
     * @var string 
     */
    protected $json = null;

    /**
     * ステータス
     * @var integer 
     */
    protected $status = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $status = empty($this->status)? PERMISSION_MEMBERS:$this->status;
        if (!($this->permission & PERMISSION_LEADER)){
            $status = PERMISSION_MEMBERS;
        }

        $this->v_com_names->setValue('ref_community', $this->community['id']);
        $this->v_com_names->setValue('visibility',    $this->visible, '&');
        $this->v_com_names->setValue('status',        $status, '&');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setAdminCommand();
        $this->_setJson();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'json'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }

    /**
     * 管理者コマンドの設定
     *
     * @access private
     * @return void
     **/
    private function _setAdminCommand()
    {
        $param = array();
        if (!($this->permission & PERMISSION_LEADER)){
            $this->objvew->assign('command', '<br />');
            $this->objvew->assign('param', $param);
            return ;
        }
        $nonce = RKT_Crypt::getNonce('manipNonce');
        
        $command    = '';
        /* メンバーに入れる */
        if ($this->status & (PERMISSION_REFUSAL | PERMISSION_REQUEST)){
            $command .= '&nbsp;<a href="'.HTTP_ACTION.'community/setting/names/';
            $command .= $this->community['id'].'/%s/confirm/'.US.'_mpnnc='.$nonce.'&amp;status=';
            $command .= PERMISSION_MEMBER.'"><img src="'.BASE_URL.'resource/img/icons/group_add.gif"';
            $command .= ' width="16" height="16" alt="'._('Add Member').'" /></a>&nbsp;';
        }

        /* 名簿から除名する */
        if ($this->status & (PERMISSION_MEMBER | PERMISSION_REQUEST)){
            $command .= '&nbsp;<a href="'.HTTP_ACTION.'community/setting/names/';
            $command .= $this->community['id'].'/%s/confirm/'.US.'_mpnnc='.$nonce.'&amp;status=';
            $command .= PERMISSION_REFUSAL.'"><img src="'.BASE_URL.'resource/img/icons/cross.gif"';
            $command .= ' width="16" height="16" alt="'._('Expulsion').'" /></a>&nbsp;';
        }

        $condition = array(
            'ref_community'=> $this->community['id'],
            'status'=>        array('&', PERMISSION_CHANGE),
        );
        $row = RKT_DB::getRow('com_names', $condition, 'count(*) as ct');
        /* 管理者の変更依頼 */
        if ($this->status == PERMISSION_MEMBER && empty($row['ct'])){
            $command .= '&nbsp;<a href="'.HTTP_ACTION.'community/setting/names/';
            $command .= $this->community['id'].'/%s/confirm/'.US.'_mpnnc='.$nonce.'&amp;status=';
            $command .= PERMISSION_CHANGE.'"><img src="'.BASE_URL.'resource/img/icons/leader_change.gif"';
            $command .= ' width="16" height="16" alt="'._('Change Leader').'" /></a>&nbsp;';
        }
        $this->objvew->assign('command', $command.'<br />');
        
        if (!empty($this->status)){
            $param = array('status'=> $this->status);
        }
        $this->objvew->assign('param', $param);
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        if ($this->json != 'json'){
            return ;
        }
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->v_com_names->setLimit(LIMIT_JSON_FRIENDS);
        $this->v_com_names->setField('ref_account');
        $names = $this->v_com_names->getValues();
        
        $list = array();
        foreach ($names as $row){
            /* プロフィール */
            $condition = array(
                'ref_account'=> $row['ref_account']
            );
            $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

            /* 画像情報の読み込み */
            $condition = array(
                'status'=>      STATUS_PHOTO_MAIN,
                'ref_account'=> $row['ref_account']
            );
            $photo  = RKT_DB::getRow('act_photo', $condition);

            $list[] = array(
                'id'=>       $row['ref_account'],
                'nickname'=> $profile['nickname'],
                'src'=>      empty($photo['thumbnail'])? NOPHOTO_SMALL:$photo['thumbnail'],
                'width'=>    empty($photo['t_width'])?   PHOTO_SMALL_SIZE:$photo['t_width'],
                'height'=>   empty($photo['t_height'])?  PHOTO_SMALL_SIZE:$photo['t_height'],
            );
        }

        $this->objvew->assign('data', json_encode($list));
    }
} // class Controller
?>
