<?php
/* SVN FILE: $Id: photo.php 443 2008-05-20 08:53:37Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 443 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:37 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 443 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:37 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_community',
        ),
        'view'=> array(
            'act_attach',
        ),
    );

    /**
     * com_community モデルオブジェクト
     * @var object 
     */
    public $com_community = null;

    /**
     * v_act_attach モデルオブジェクト
     * @var object 
     */
    public $v_act_attach = null;

    /**
     * アルバムID
     * @var integer 
     */
    protected $ref_album = null;

    /**
     * ID
     * @var integer 
     */
    protected $selected = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_community->setCurId($this->id);

        if ($this->ref_album != ''){
            $this->v_act_attach->setValue('ref_album', $this->ref_album);
        }
        $this->v_act_attach->setValue('ref_account', $this->account['id']);
        $this->v_act_attach->setLimit(LIMIT_TILE);
        $this->v_act_attach->setOrder('modified DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->permission & PERMISSION_LEADER)){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        if ($this->checked_nonce){
            if ($this->com_community->catchFile('photo')){
                $this->com_community->manip();
            }

            if (!empty($_POST['select'])){
                $this->_selectPhoto();
            }
            
            if ($this->action == 'delete'){
                $this->com_community->deletePhoto();
                $this->com_community->manip();
            }
        } // if ($this->checked_nonce)

        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $albums = RKT_DB::getList('act_album', $condition);
        $this->objvew->assign('albums', $albums);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'ref_album'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'selected'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 画像の選択
     *
     * @access public
     * @return void
     **/
    protected function _selectPhoto()
    {
        $row = RKT_DB::getRow('act_attach', $this->selected);
        
        $this->com_community->selectedPhoto($row['origin']);
        $this->com_community->manip();
    }
} // class Controller
?>
