<?php
/* SVN FILE: $Id: community.php 370 2008-05-13 04:34:21Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 370 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-13 13:34:21 +0900 (火, 13 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 370 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-13 13:34:21 +0900 (火, 13 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_community',
        ),
        'view'=> array(
            'com_community',
        ),            
    );

    /**
     * com_community モデルオブジェクト
     * @var object 
     */
    public $com_community = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_community->setCurId($this->id);
        $this->com_community->setValue('ref_account', $this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        /* 新規コミュニティ判定 */
        if (empty($this->id)){
            if ($this->account['status'] == STATUS_GUEST){
                throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
            }
            /* ヘッダーメニューの切り替え */
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
            $this->objvew->setTemplate('sidebar_tpl', 'common/menu/communitySearch.tpl');
            $this->objvew->addCss('css/private.css');
            $this->objvew->baseAssign('member',  $this->account);
        } else {
            if (!($this->permission & PERMISSION_LEADER)){
                throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
            }
        } // if (empty($this->id))
        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_PRIVATE=>   _('Private'),
        );
        $this->objvew->assign('visibility', $visibility);

        $involved = array(
            PERMISSION_MEMBER=>  _('Anyone can be involved'),
            PERMISSION_REQUEST=> _('Who must approve Admin'),
        );
        $this->objvew->assign('involved', $involved);

        $permission = array(
            PERMISSION_MEMBERS=> _('All Members'),
            PERMISSION_LEADER=>   _('Only Admin'),
        );
        $this->objvew->assign('permission', $permission);

        $this->id = $this->com_community->getCurId();
        $this->objvew->assign('id', $this->id);
    }
} // class Controller
?>
