<?php
/* SVN FILE: $Id: post.php 232 2008-05-02 18:56:05Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_topic',
        ),
        'view'=> array(
        ),            
    );

    /**
     * com_topic モデルオブジェクト
     * @var object 
     */
    public $com_topic = null;

    /**
     * トピックID
     * @var integer 
     */
    protected $ref_topic = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_topic->setCurId($this->ref_topic);

        $this->com_topic->setValue('ref_community', $this->community['id']);
        $this->com_topic->setValue('ref_author',    $this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->permission & $this->community['topic_flag'])){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();

        $img = '<img src="'.BASE_URL.'resource/img/icons/%s" width="16" height="16" align="absmiddle" />&nbsp;';
        $visibility = array(
            VISIBILITY_PUBLIC=>    sprintf($img, 'world.gif') . _('Public'),
            VISIBILITY_PROTECTED=> sprintf($img, 'user.gif') . _('Members'),
            VISIBILITY_PRIVATE=>   sprintf($img, 'group_key.gif') . _('Private'),
        );
        $this->objvew->assign('visibility', $visibility);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_topic'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
