<?php
/* SVN FILE: $Id: report.php 232 2008-05-02 18:56:05Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_report',
        ),
        'view'=> array(
        ),            
    );

    /**
     * com_report モデルオブジェクト
     * @var object 
     */
    public $com_report = null;

    /**
     * イベント(Member_Controllerで取得)
     * @var array
     */
    protected $event = null;

    /**
     * レポートID
     * @var integer
     */
    protected $ref_report = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_report->setCurId($this->ref_report);

        $this->com_report->setValue('ref_community', $this->community['id'], RKT_Model::CONDITION);
        $this->com_report->setValue('ref_event',     $this->id, RKT_Model::CONDITION);
        $this->com_report->setValue('ref_author',    $this->account['id'], RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->visible & $this->event['visibility'])){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }
        $this->objvew->setRichEditor();
        $this->objvew->assign('event', $this->event);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_report'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
