<?php
/* SVN FILE: $Id: entries.php 232 2008-05-02 18:56:05Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_attend'
        ),
        'view'=> array(
            'com_attend',
        ),            
    );

    /**
     * com_attend モデルオブジェクト
     * @var object 
     */
    public $v_com_attend = null;

    /**
     * イベント(Member_Controllerで取得)
     * @var array
     */
    protected $event = null;

    /**
     * 削除ユーザーID
     * @var integer
     */
    protected $delete = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->v_com_attend->setValue('ref_event', $this->event['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->permission & PERMISSION_MEMBERS)){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }
        
        $this->_deleteEntries();
        $this->objvew->assign('event', $this->event);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'delete'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 参加一覧からの削除
     *
     * @access private
     * @return void
     **/
    private function _deleteEntries()
    {
        if ($this->checked_nonce && ($this->permission & PERMISSION_LEADER)){
            $this->com_attend->setValue('ref_event',     $this->event['id'],     RKT_Model::CONDITION);
            $this->com_attend->setValue('ref_community', $this->community['id'], RKT_Model::CONDITION);
            $this->com_attend->setValue('ref_account',   $this->delete,          RKT_Model::CONDITION);

            $this->com_attend->setDelete();
            $this->com_attend->manip();
        }

        $nonce = RKT_Crypt::getNonce('manipNonce');
        $command = '';
        if ($this->event['ref_author'] == $this->account['id'] || $this->permission & PERMISSION_MEMBERS){
            $command .= '&nbsp;<a href="'.HTTP_ACTION.'community/event/entries/';
            $command .= $this->event['id'].'/'.US.'_mpnnc='.$nonce.'&amp;delete=%s';
            $command .= '"><img src="'.BASE_URL.'resource/img/icons/cross.gif"';
            $command .= ' width="16" height="16" alt="'._('Expulsion').'" /></a>&nbsp;';
        }
        $this->objvew->assign('command', $command);
    }
} // class Controller
?>
