<?php
/* SVN FILE: $Id: view.php 412 2008-05-18 07:46:01Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'com_trackback',
        ),            
    );

    /**
     * com_trackback モデルオブジェクト
     * @var object 
     */
    public $v_com_trackback = null;

    /**
     * 記事(Member_Controllerで取得)
     * @var array
     */
    protected $article = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/articleSearch.tpl');

        $this->v_com_trackback->setValue('ref_community', $this->community['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();
        $this->objvew->assign('article', $this->article);

        $this->objvew->assign('lastHour',  strtotime('-1 hour'));
        $this->objvew->assign('lastHours', strtotime('-12 hour'));
        $this->objvew->assign('lastDay',   strtotime('-1 day'));
        $this->objvew->assign('pastWeek',  strtotime('-7 day'));
        $this->objvew->assign('pastMonth', strtotime('-31 day'));

        $this->objvew->assign('page', 'list/'.$this->community['id']);
    }
} // class Controller
?>
