<?php
/* SVN FILE: $Id: list.php 412 2008-05-18 07:46:01Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'com_article',
        ),            
    );

    /**
     * com_article モデルオブジェクト
     * @var object 
     */
    public $v_com_article = null;

    /**
     * サマリーアクション
     * @var string
     */
    protected $summary = null;

    /**
     * サマリーリスト
     * @var array
     */
    private $_list = array();

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/articleSearch.tpl');

        $this->v_com_article->setValue('ref_community', $this->community['id']);
        $this->v_com_article->setValue('visibility',    $this->visible, '&');
        $this->v_com_article->setOrder('regist_date DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setViewEditor();
        $this->_setSummary();

        $this->objvew->assign('lastHour',  strtotime('-1 hour'));
        $this->objvew->assign('lastHours', strtotime('-12 hour'));
        $this->objvew->assign('lastDay',   strtotime('-1 day'));
        $this->objvew->assign('pastWeek',  strtotime('-7 day'));
        $this->objvew->assign('pastMonth', strtotime('-31 day'));

        $this->objvew->assign('page', 'list/'.$this->community['id']);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'summary'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * Summaryデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setSummary()
    {
        if (empty($this->summary)){
            return ;
        }

        $result = $this->v_com_article->getValues();
        foreach ($result as $row){
            /* プロフィール */
            $condition = array(
                'ref_account'=> $row['ref_author']
            );
            $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

            $this->_list[] = array(
                'title'=>       $row['article'],
                'link'=>        HTTP_ACTION.'community/article/view/'.$row['id'].'/',
                'modified'=>    $row['modified'],
                'date'=>        fDate($row['modified'], _('Y-m-d')),
                'creator'=>     $profile['nickname'],
                'description'=> strip_tags($row['comment']),
            );
        }
        
        if ($this->summary == 'json'){
            $this->_setJson();
        } elseif ($this->summary == 'php'){
            $this->_setPhp();
        } else {
            $this->_setXml();
        }
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->objvew->assign('data', json_encode($this->_list));
    }

    /**
     * PHPデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setPhp()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $serialized = serialize($this->_list);

        $this->objvew->assign('data', $serialized);
    }

    /**
     * XMLデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setXml()
    {
        if ($this->summary == 'rss'){
            $this->objvew->setBaseFile('common/summary/rss.tpl');
        } elseif ($this->summary == 'atom') {
            $this->objvew->setBaseFile('common/summary/atom.tpl');
        } elseif ($this->summary == 'rdf') {
            $this->objvew->setBaseFile('common/summary/rdf.tpl');
        } else {
            return ;
        }
        $this->objvew->setMimeType('text/xml');
        $modified = empty($this->_list[0]['modified'])? 'now':$this->_list[0]['modified'];

        /* プロフィール */
        $condition = array(
            'ref_account'=> $this->community['ref_account']
        );
        $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

        $summary = array(
            'title'=>       $this->community['community'],
            'link'=>        HTTP_ACTION.'community/article/list/'.$this->community['id'].'/',
            'modified'=>    $modified,
            'creator'=>     $profile['nickname'],
            'description'=> strip_tags($this->community['comment']),
            'list'=>        $this->_list
        );

        $this->objvew->assign('summary', $summary);
    }
} // class Controller
?>
