<?php
/* SVN FILE: $Id: plugins.php 552 2008-06-07 04:16:32Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 552 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-07 13:16:32 +0900 (土, 07 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 552 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-07 13:16:32 +0900 (土, 07 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
        ),            
    );

    /**
     * des_theme モデルオブジェクト
     * @var object 
     */
    public $des_theme = null;

    /**
     * プラグイン
     * @var string
     */
    protected $plugins = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/site.tpl');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $result = false;
        $files = glob(PLUGIN_DIR.'{*}', GLOB_BRACE);
        
        foreach ($files as $filename){
            if (is_dir($filename)){
                if (file_exists($filename.DS.'packages.php')){
                    include $filename.DS.'packages.php';
                }
            }
        } // foreach ($files as $filename)

        if ($this->checked_nonce){
            $result = $this->_updateConfig();
        }

        $infos = empty($GLOBALS['INFO_PLUGIN'])? array():$GLOBALS['INFO_PLUGIN'];
        $this->objvew->assign('plugins', $infos);
        $this->objvew->assign('complete', $result);
    }


    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'plugins'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }

    /**
     * スタイルシートの置換
     *
     * @access private
     * @param string $filename
     * @return boolean  データ操作結果
     */
    public function _updateConfig()
    {
        $anchor = array(
            'start>>>>>',
            '<<<<<end',
            '<<<<<*>>>>>'
        );

        /* ファイルの中身を取得 */
        $handle = fopen(PLUGIN_DIR.'config.php', 'r');
        if (!is_resource($handle)) {
            return false;
        }

        $buff = array('', '', '');
        $pos = 0;
        while (!feof($handle)) {
            $line  = fgets($handle, 4096);
            $match = strpos($line, $anchor[$pos]);
            if ($match !== false){
                $pos++;
            }            
            $buff[$pos] .= $line;
        }
        fclose($handle);
        
        $buff[1]  = '/* start>>>>> */'."\r\n".'$GLOBALS[\'LOADS_PLUGIN\'] = array('."\r\n";
        foreach ($this->plugins as $key){
            $buff[1] .= '    '."'".$key."'=> '".$GLOBALS['INFO_PLUGIN'][$key]['plugin']."',\r\n";
        }
        $buff[1] .= ');'."\r\n";

        /* ファイルの中身を取得 */
        $handle = fopen(PLUGIN_DIR.'config.php', 'w');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $buff[0].$buff[1].$buff[2]);
        fclose($handle);
        
        return $result;
    }
} // class Controller
?>
