<?php
/* SVN FILE: $Id: article.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'atc_article',
        ),
        'view'=> array(
        ),            
    );

    /**
     * atc_article モデルオブジェクト
     * @var object 
     */
    public $atc_article = null;

    /**
     * 記事ID
     * @var integer 
     */
    public $ref_article = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/site.tpl');
        $this->atc_article->setCurId($this->ref_article);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setRichEditor();

        $img = '<img src="'.BASE_URL.'resource/img/icons/%s" width="16" height="16" align="absmiddle" />&nbsp;';
        $visibility = array(
            VISIBILITY_PUBLIC=>    sprintf($img, 'world.gif') .     _('Public'),
            VISIBILITY_PROTECTED=> sprintf($img, 'user.gif') .      _('Members'),
            VISIBILITY_HIDDEN=>    sprintf($img, 'page_edit.gif') . _('Draft'),
        );
        $this->objvew->assign('visibility', $visibility);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_article'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
