<?php
/* SVN FILE: $Id: send.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rkt_message.php';

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_message',
            'sys_message',
        ),
        'view'=> array(
            'viw_account',
        ),            
    );

    /**
     * fri_message モデルオブジェクト
     * @var object 
     */
    public $fri_message = null;

    /**
     * sys_message モデルオブジェクト
     * @var object 
     */
    public $sys_message = null;

    /**
     * viw_account モデルオブジェクト
     * @var object 
     */
    public $v_viw_account = null;

    /**
     * アカウントID
     * @var integer 
     */
    protected $id = null;

    /**
     * アクション引数
     * @var string
     */
    protected $param = null;

    /**
     * メール用本文
     * @var string
     */
    private $_body = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/message.tpl');

        $this->sys_message->setCurId($this->id);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_message = RKT_DB::getRow('sys_message', $this->id);

        if ($this->param == 'json'){
            $this->_setJson();
        } else {
            $this->_setPage();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'param'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 一般ページの設定
     *
     * @access private
     * @return void
     **/
    private function _setPage()
    {
        $this->objvew->addJavas('yui/animation/animation-min.js');

        $this->objvew->assign('status', MESSAGE_SENT);
        $statuses = array(
            MESSAGE_INBOX=> _('Inbox'),
            MESSAGE_SENT=>  _('Sent'),
            MESSAGE_DRAFT=> _('Draft'),
            MESSAGE_TRASH=> _('Trash'),
        );
        $this->objvew->assign('statuses', $statuses);

        $munu_class = array(
            MESSAGE_INBOX=> '',
            MESSAGE_SENT=>  ' class="column"',
            MESSAGE_DRAFT=> '',
            MESSAGE_TRASH=> '',
        );
        $this->objvew->assign('menu_class', $munu_class);

        $types = array(
            SEND_TYPE_MESSAGE=> _('Message'),
            SEND_TYPE_EMAIL=>   _('E-mail'),
            SEND_TYPE_BOTH=>    _('Message & E-mail'),
        );
        $this->objvew->assign('types', $types);

        if ($this->checked_nonce){
            if (!empty($_POST['start'])){
                $this->objvew->assign('start', true);
            }
        }

        /* 引数の設定 */
        $pages = $this->v_viw_account->getInfo();
        $pages['param']['last_name']  = RKT_Crypt::getDecrypted($pages['param']['last_name']);
        $pages['param']['first_name'] = RKT_Crypt::getDecrypted($pages['param']['first_name']);
        $pages['param']['email']      = RKT_Crypt::getDecrypted($pages['param']['email']);
        $this->objvew->assign('query', http_build_query($pages['param']));
    }

    /**
     * Jsonデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        /* 一覧の送信 */
        $this->_sendList();
        
        $pages = $this->v_viw_account->getInfo();
        $per   = 100;
        if (!empty($pages['max_page'])){
            $per = ($pages['page'] / $pages['max_page'])*100;
        }
        $complete = false;
        if (!$pages['next_bool']){
            $per      = 100;
            $complete = true;
            
            $this->sys_message->setValue('status', MESSAGE_SENT);
            $this->sys_message->manip();
        }

        $list = array(
            'per'=>      $per,
            'next'=>     $pages['next'],
            'complete'=> $complete,
        );
        $this->objvew->assign('data', json_encode($list));
    }

    /**
     * 一覧の送信
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _sendList()
    {
        $result = $this->v_viw_account->getValues();
        $list   = array();

        if ($this->sys_message->send_type == SEND_TYPE_MESSAGE){
            /* メッセージ用リスト作成 */
            foreach ($result as $account){
                $list[] = $account['id'];
            }
        } else {
            $this->_body = str_replace('<br>', "\r\n", $this->sys_message->body);
            $this->_body = strip_tags($this->_body);
            /* メール送信 */
            foreach ($result as $account){
                $account['email'] = RKT_Crypt::getDecrypted($account['email']);
                $list[] = $account['id'];
                $this->_sendMail($account);
            }
        } // if ($this->sys_message->send_type == SEND_TYPE_MESSAGE)

        /* メッセージ送信 */
        if ($this->sys_message->send_type != SEND_TYPE_EMAIL){
            $this->_sendMessage($list);
        }
    }

    /**
     * メール送信
     *
     * @access private
     */
    private function _sendMail($account)
    {
        $objsnd = RKT_Message::getInstance('mailing');

        $objsnd->Assign('user_name',     $account['nickname']);
        $objsnd->Assign('body',          $this->_body."\r\n");
        $objsnd->send($account['email'], $this->sys_message->subject);
    }

    /**
     * メッセージ送信
     *
     * @access private
     */
    private function _sendMessage($accounts)
    {
        $this->fri_message->setValue('status',      MESSAGE_SENT);
        $this->fri_message->setValue('ref_account', $this->account['id']);
        $this->fri_message->setValue('ref_to',      $this->account['id']);
        $this->fri_message->setValue('ref_from',    $this->account['id']);
        $this->fri_message->setValue('ref_message', 0);
        $this->fri_message->setValue('flag',        FLAG_READ);

        $this->fri_message->setValue('subject',     $this->sys_message->subject);
        $this->fri_message->setValue('body',        $this->sys_message->body);
        
        $this->fri_message->setToList($accounts);
        $this->fri_message->sendMultiple();
    }
} // class Controller
?>
