<?php
/* SVN FILE: $Id: message.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    var $models = array(
        'manip'=> array(
            'sys_message',
        ),
        'view'=> array(
        ),            
    );

    /**
     * sys_message モデルオブジェクト
     * @var object 
     */
    var $sys_message = null;

    /**
     * アカウントID
     * @var integer 
     */
    protected $id = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/message.tpl');

        $this->sys_message->setCurId($this->id);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function action()
    {
        $this->objvew->setRichEditor();

        $this->objvew->assign('status', MESSAGE_INBOX);
        $statuses = array(
            MESSAGE_INBOX=> _('Inbox'),
            MESSAGE_SENT=>  _('Sent'),
            MESSAGE_DRAFT=> _('Draft'),
            MESSAGE_TRASH=> _('Trash'),
        );
        $this->objvew->assign('statuses', $statuses);

        $munu_class = array(
            MESSAGE_INBOX=> ' class="column"',
            MESSAGE_SENT=>  '',
            MESSAGE_DRAFT=> '',
            MESSAGE_TRASH=> '',
        );
        $this->objvew->assign('menu_class', $munu_class);

        $types = array(
            SEND_TYPE_MESSAGE=> _('Message'),
            SEND_TYPE_EMAIL=>   _('E-mail'),
            SEND_TYPE_BOTH=>    _('Message & E-mail'),
        );
        $this->objvew->assign('types', $types);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
