<?php
/* SVN FILE: $Id: category.php 514 2008-05-26 09:06:21Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 514 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-26 18:06:21 +0900 (月, 26 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 514 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-26 18:06:21 +0900 (月, 26 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'cnt_category',
        ),
        'view'=> array(
        ),            
    );

    /**
     * cnt_category モデルオブジェクト
     * @var object 
     */
    public $cnt_category = null;

    /**
     * カテゴリID
     * @var integer
     */
    public $id = null;

    /**
     * 更新リスト
     * @var array
     */
    public $updates = null;

    /**
     * 削除リスト
     * @var array
     */
    public $deletes = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/contact.tpl');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->checked_nonce){
            $this->_updateCategories();
            $this->_deleteCategories();
        }

        $munu_class = array(
            CONTACT_NEW=>       '',
            CONTACT_PENDING=>   '',
            CONTACT_RESPONDED=> '',
            CONTACT_TRASH=>     '',
            'category'=>        ' class="column"',
        );
        $this->objvew->assign('menu_class', $munu_class);

        $list = RKT_DB::getList('cnt_category', null, '*', 'sort');
        $this->objvew->assign('categories', $list);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'updates'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'deletes'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 更新リストの処理
     *
     * @access private
     * @return void
     **/
    private function _updateCategories()
    {
        if (empty($_POST['manips'])){
            return ;
        }
        if (empty($this->updates)){
            return ;
        }

        foreach ($this->updates as $id=>$row){
            $this->cnt_category->setCurId($id);
            $this->cnt_category->setInitValue();

            $this->cnt_category->setValue('sort',     $row['sort']);
            $this->cnt_category->setValue('category', $row['category']);
            $this->cnt_category->manip();

            $this->cnt_category->refreshColumn();
        }
    }

    /**
     * 削除リストの処理
     *
     * @access private
     * @return void
     **/
    private function _deleteCategories()
    {
        if (empty($_POST['delete'])){
            return ;
        }
        if (empty($this->deletes)){
            return ;
        }

        foreach ($this->deletes as $id){
            $this->cnt_category->setCurId($id);
            $this->cnt_category->setDelete();
            $this->cnt_category->manip();
        }
    }
} // class Controller
?>
