<?php
/* SVN FILE: $Id: items.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_item',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_item モデルオブジェクト
     * @var object 
     */
    public $act_item = null;

    /**
     * 更新リスト
     * @var array
     */
    public $updates = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/profile.tpl');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->checked_nonce){
            $this->_updateItems();
        }

        $list = RKT_DB::getList('act_item', null, '*', 'sort');
        $this->objvew->assign('items', $list);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'updates'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 更新リストの処理
     *
     * @access private
     * @return void
     **/
    private function _updateItems()
    {
        if (empty($_POST['manips'])){
            return ;
        }
        if (empty($this->updates)){
            return ;
        }

        $this->act_item->setUpdate();
        foreach ($this->updates as $id=>$row){
            $this->act_item->setCurId($id);
            $this->act_item->setInitValue();

            $this->act_item->setValue('sort', $row['sort']);
            $this->act_item->manip();

            $this->act_item->refreshColumn();
        }
    }
} // class Controller
?>
