<?php
/* SVN FILE: $Id: analyze.php 499 2008-05-25 12:49:04Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 499 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:49:04 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 499 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:49:04 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 一週間
     * @var array
     */
    private $_weekly = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/accountSearch.tpl');
        $time = array(
            strtotime('-6 day'), 
            strtotime('-5 day'),
            strtotime('-4 day'),
            strtotime('-3 day'),
            strtotime('-2 day'),
            strtotime('-1 day'),
            time(),
        );
        
        $this->_weekly = array();
        $weekly = array();
        foreach ($time as $row){
            $date = date('d', $row);
            $this->_weekly[$date] = date('Y-m-d', $row);
            $weekly[] = $date;
        }
        $this->objvew->assign('weekly', $weekly);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->addJavas('yui/element/element-beta-min.js');
        $this->objvew->addJavas('yui/datasource/datasource-beta-min.js');
        $this->objvew->addJavas('yui/charts/charts-experimental-min.js');
        
        $this->_setNewMember();
        $this->_setWithdrawal();
        $this->_setNonMobileAccess();
        $this->_setMobileAccess();
        
        $this->_setGenderRatio();
        $this->_setGenerationRatio();
    }

    /**
     * 新会員の設定
     *
     * @access private
     * @return void
     **/
    private function _setNewMember()
    {
        $result = array();
        foreach ($this->_weekly as $day=>$date) {
            $condition = array(
                array('regist_date', '>=', $date.' 00:00:00'),
                array('regist_date', '<=', $date.' 23:59:59'),
            );
            $row = RKT_DB::getRow('act_account', $condition, 'count(*) as ct');
            
            $result[$day] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('newface', $result);
    }

    /**
     * 退会者の設定
     *
     * @access private
     * @return void
     **/
    private function _setWithdrawal()
    {
        $result = array();
        foreach ($this->_weekly as $day=>$date) {
            $condition = array(
                array('modified', '>=', $date.' 00:00:00'),
                array('modified', '<=', $date.' 23:59:59'),
            );
            $row = RKT_DB::getRow('act_cancel', $condition, 'count(*) as ct');
            
            $result[$day] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('resign', $result);
    }

    /**
     * モバイル以外のアクセス設定
     *
     * @access private
     * @return void
     **/
    private function _setNonMobileAccess()
    {
        $result = array();
        foreach ($this->_weekly as $day=>$date) {
            $condition = array(
                array('modified','>=', $date.' 00:00:00'),
                array('modified','<=', $date.' 23:59:59'),
                array('ismobile', '=', '0'),
                array('target',   '=', RKT_access::TARGET_MEMBER),
            );
            $row = RKT_DB::getRow('log_access', $condition, 'count(*) as ct');
            
            $result[$day] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('nonm', $result);
    }

    /**
     * モバイルのアクセス設定
     *
     * @access private
     * @return void
     **/
    private function _setMobileAccess()
    {
        $result = array();
        foreach ($this->_weekly as $day=>$date) {
            $condition = array(
                array('modified','>=', $date.' 00:00:00'),
                array('modified','<=', $date.' 23:59:59'),
                array('ismobile', '=', '1'),
                array('target',   '=', RKT_access::TARGET_MEMBER),
            );
            $row = RKT_DB::getRow('log_access', $condition, 'count(*) as ct');
            
            $result[$day] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('mobile', $result);
    }

    /**
     * 男女比の設定
     *
     * @access private
     * @return void
     **/
    private function _setGenderRatio()
    {
        $result = array();
        for ($id=1; $id<=3; $id++) {
            $condition = array(
                'ref_gender'=> $id,
            );
            $row = RKT_DB::getRow('act_profile', $condition, 'count(*) as ct');
            
            $result[$id] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('gender', $result);
    }

    /**
     * 世代比率設定
     *
     * @access private
     * @return void
     **/
    private function _setGenerationRatio()
    {
        $result = array();
        /* 20代以下 */
        $condition = array(
            array('birthday', '>=', date('Y-m-d', strtotime('-29 years'))),
        );
        $row = RKT_DB::getRow('act_profile', $condition, 'count(*) as ct');        
        $result[] = empty($row['ct'])? 0:$row['ct'];

        /* 30代 */
        $condition = array(
            array('birthday', '>=', date('Y-m-d', strtotime('-39 years'))),
            array('birthday', '<=', date('Y-m-d', strtotime('-30 years'))),
        );
        $row = RKT_DB::getRow('act_profile', $condition, 'count(*) as ct');        
        $result[] = empty($row['ct'])? 0:$row['ct'];

        /* 40代 */
        $condition = array(
            array('birthday', '>=', date('Y-m-d', strtotime('-49 years'))),
            array('birthday', '<=', date('Y-m-d', strtotime('-40 years'))),
        );
        $row = RKT_DB::getRow('act_profile', $condition, 'count(*) as ct');        
        $result[] = empty($row['ct'])? 0:$row['ct'];

        /* 50代 */
        $condition = array(
            array('birthday', '>=', date('Y-m-d', strtotime('-59 years'))),
            array('birthday', '<=', date('Y-m-d', strtotime('-50 years'))),
        );
        $row = RKT_DB::getRow('act_profile', $condition, 'count(*) as ct');        
        $result[] = empty($row['ct'])? 0:$row['ct'];

        /* 60歳以上 */
        $condition = array(
            array('birthday', '<=', date('Y-m-d', strtotime('-60 years'))),
        );
        $row = RKT_DB::getRow('act_profile', $condition, 'count(*) as ct');        
        $result[] = empty($row['ct'])? 0:$row['ct'];

        $this->objvew->assign('generation', $result);
    }
} // class Controller
?>
