<?php
/* SVN FILE: $Id: account.php 538 2008-06-05 17:22:44Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 538 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-06 02:22:44 +0900 (金, 06 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 538 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-06 02:22:44 +0900 (金, 06 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_account',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_account モデルオブジェクト
     * @var object 
     */
    public $act_account = null;

    /**
     * アカウントID
     * @var integer 
     */
    protected $id = null;

    /**
     * 有効・無効
     * @var integer 
     */
    protected $avail = null;

    /**
     * ステータス
     * @var integer 
     */
    protected $status = null;

    /**
     * メールアドレス１
     * @var string 
     */
    protected $email = null;

    /**
     * メールアドレス２
     * @var string 
     */
    protected $verify_email = null;

    /**
     * パスワード１
     * @var string 
     */
    protected $password = null;

    /**
     * パスワード２
     * @var string 
     */
    protected $verification = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/accountSearch.tpl');
        $this->act_account->setCurId($this->id);
        if ($this->avail !== ''){
            $this->act_account->setValue('avail', $this->avail);
        }
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setOptions();
        $this->_email();
        $this->_password();

        unset($_SESSION['verify_email']);
        unset($_SESSION['verification']);
        unset($_SESSION['password']);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'avail'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> false
            ),
            'verify_email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> false
            ),
            'password'=> array(
                'type'=>     'string',
                'option'=>   array(
                    'format'=> '\w+',
                    'min_length'=>4,
                    'max_length'=>16
                ),
                'required'=> false
            ),
            'verification'=> array(
                'type'=>     'string',
                'option'=>   array(
                    'format'=> '\w+',
                    'min_length'=>4,
                    'max_length'=>16
                ),
                'required'=> false
            ),
        );
    }

    /**
     * 選択肢の設定
     *
     * @abstract
     * @access protected
     * @return void
     */
    private function _setOptions()
    {
        $list = array(
            STATUS_ENABLE=>  _('Enable'),
            STATUS_DISABLE=> _('Disable'),
        );
        $this->objvew->assign('avail', $list);

        $type = array (
            STATUS_ADMIN => _('Administrator'),
            STATUS_MEMBER=> _('Member'),
        );
        $this->objvew->assign('types', $type);

        $type = array (
            DELIVERY_DAILY => _('Daily'),
            DELIVERY_WEEK=>   _('Twice a week(Mon/Thu)'),
            DELIVERY_REFUSE=> _('Refuse'),
        );
        $this->objvew->assign('deliveries', $type);

        $type = array (
            STATUS_ENABLE => _('To receive mail'),
            STATUS_DISABLE=> _('Do not receive mail'),
        );
        $this->objvew->assign('mailings', $type);
    }

    /**
     * メールアドレス
     *
     * @access private
     * @return void
     **/
    private function _email()
    {
        if (empty($this->email)){
            return ;
        }

        if ($this->email != $this->verify_email){
            $this->act_account->objrqt->setAlert('unmatched_email');
        } else {
            $_SESSION['email'] = $this->email;
        }

        $this->objvew->assign('changed_email', true);
    }

    /**
     * パスワード
     *
     * @access private
     * @return void
     **/
    private function _password()
    {
        if (empty($this->password)){
            return ;
        }

        if ($this->password != $this->verification){
            $this->act_account->objrqt->setAlert('unmatched_password');
        } else {
            $_SESSION['hashed_password'] = $this->password;
        }

        $this->objvew->assign('changed_password', true);
    }
} // class Controller
?>
