-- SVN FILE: $Id: create.sql 457 2008-05-22 09:25:54Z bb_yujiro $
--
-- テーブル定義
--
-- PHP versions 5
--
--      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
--      Copyright (c) 2007 Yujiro Takahashi
--
-- Licensed under The MIT License
-- Redistributions of files must retain the above copyright notice.
--
-- @filesource
-- @copyright       Copyright (c) 2007 Yujiro Takahashi
-- @link            http://rakuto.net/
-- @author          Yujiro Takahashi <yujiro@rakuto.net>
-- @package         rktFW
-- @version         $Revision: 457 $
-- @modifiedby      $LastChangedBy: bb_yujiro $
-- @lastmodified    $Date: 2008-05-22 18:25:54 +0900 (木, 22 5 2008) $
-- @license         http://opensource.org/licenses/mit-license.php The MIT License
-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_account`
-- 

CREATE TABLE `sns_act_account` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `last_login` datetime NOT NULL default '0000-00-00 00:00:00',
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `avail` int(11) NOT NULL default '1',
  `status` int(11) NOT NULL,
  `hashed_password` varchar(40) NOT NULL,
  `email` blob,
  `hashed_email` varchar(40) default NULL,
  `news` int(11) default '0',
  `mailing` int(11) default NULL,
  `footprint` int(11) default '0',
  `access_number` int(11) default '0',
  `friend_number` int(11) default '0',
  `block` text,
  `ref_theme` int(11) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email_hash` (`hashed_email`),
  KEY `last_login` (`last_login`),
  KEY `friend_number` (`friend_number`),
  KEY `access_number` (`access_number`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_album`
-- 

CREATE TABLE `sns_act_album` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `album` varchar(255) NOT NULL,
  `visibility` int(11) NOT NULL default '1',
  `comment` text,
  `posts` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_attach`
-- 

CREATE TABLE `sns_act_attach` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `ref_album` int(11) NOT NULL default '0',
  `title` varchar(255) default NULL,
  `mime_type` varchar(64) NOT NULL default 'empty',
  `origin` varchar(255) default NULL,
  `filename` varchar(255) default NULL,
  `width` int(11) default '0',
  `height` int(11) default '0',
  `thumbnail` varchar(255) default NULL,
  `t_width` int(11) default '0',
  `t_height` int(11) default '0',
  `v_small` varchar(255) default NULL,
  `v_width` int(11) default '0',
  `v_height` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `modified` (`modified`),
  KEY `ref_album` (`ref_album`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_autologin`
-- 

CREATE TABLE `sns_act_autologin` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `loginkey` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `loginkey` (`loginkey`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_blood`
-- 

CREATE TABLE `sns_act_blood` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `blood` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_cancel`
-- 

CREATE TABLE `sns_act_cancel` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_account` int(11) NOT NULL,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `reason` text,
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_gadget`
-- 

CREATE TABLE `sns_act_gadget` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `position` int(11) NOT NULL default '2',
  `sort` int(11) NOT NULL default '1',
  `display` int(11) NOT NULL default '1',
  `list_number` int(11) NOT NULL default '5',
  `ref_feed` int(11) default '0',
  `title` varchar(255) NOT NULL,
  `source` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_gender`
-- 

CREATE TABLE `sns_act_gender` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `gender` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_item`
-- 

CREATE TABLE `sns_act_item` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL default '1',
  `item` varchar(255) NOT NULL,
  `required` int(11) NOT NULL,
  `visible` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `answers` text,
  PRIMARY KEY  (`id`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_married`
-- 

CREATE TABLE `sns_act_married` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `married` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_mobile`
-- 

CREATE TABLE `sns_act_mobile` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `email` blob,
  `hashed_email` varchar(32) default NULL,
  `loginkey` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `hashed_email` (`hashed_email`),
  UNIQUE KEY `loginkey` (`loginkey`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_personality`
-- 

CREATE TABLE `sns_act_personality` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_item` int(11) NOT NULL default '1',
  `ref_account` int(11) NOT NULL default '1',
  `visibility` int(11) default NULL,
  `personal` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ref_item` (`ref_item`,`ref_account`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_photo`
-- 

CREATE TABLE `sns_act_photo` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_account` int(11) NOT NULL,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `status` int(11) default NULL,
  `filename` varchar(255) default NULL,
  `width` int(11) default NULL,
  `height` int(11) default NULL,
  `thumbnail` varchar(255) default NULL,
  `t_width` int(11) default NULL,
  `t_height` int(11) default NULL,
  `v_small` varchar(255) default NULL,
  `v_width` int(11) default NULL,
  `v_height` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_profile`
-- 

CREATE TABLE `sns_act_profile` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_account` int(11) NOT NULL,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `first_name` blob NOT NULL,
  `last_name` blob NOT NULL,
  `name_flag` int(11) NOT NULL default '1',
  `nickname` varchar(128) NOT NULL,
  `visibility` int(11) NOT NULL default '1',
  `ref_region` int(11) NOT NULL default '0',
  `ref_city` int(11) default '0',
  `region_flag` int(11) NOT NULL default '1',
  `ref_gender` int(11) NOT NULL default '3',
  `gender_flag` int(11) NOT NULL default '1',
  `ref_blood` int(11) NOT NULL default '5',
  `blood_flag` int(11) NOT NULL default '1',
  `birthday` date NOT NULL default '0000-00-00',
  `birthday_flag` int(11) NOT NULL default '1',
  `age_flag` int(11) NOT NULL default '1',
  `ref_married` int(11) NOT NULL default '1',
  `married_flag` int(11) default '1',
  `ref_hometown` int(11) default '0',
  `ref_homecity` int(11) default '0',
  `hometown_flag` int(11) default '1',
  `photo` int(11) NOT NULL default '0',
  `comment` text,
  `taste` text,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `nickname` (`nickname`),
  KEY `ref_gender` (`ref_gender`),
  KEY `birthday` (`birthday`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_act_taste`
-- 

CREATE TABLE `sns_act_taste` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `taste` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_ara_area`
-- 

CREATE TABLE `sns_ara_area` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `area` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_ara_city`
-- 

CREATE TABLE `sns_ara_city` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_region` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `city` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_region` (`ref_region`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_ara_region`
-- 

CREATE TABLE `sns_ara_region` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_area` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `region` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_area` (`ref_area`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_atc_article`
-- 

CREATE TABLE `sns_atc_article` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL,
  `subject` varchar(255) NOT NULL,
  `status` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `body` text NOT NULL,
  `trackbacks` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `regist_date` (`regist_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_atc_trackback`
-- 

CREATE TABLE `sns_atc_trackback` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `ref_article` int(11) NOT NULL,
  `ref_author` int(11) default '0',
  `flag` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `excerpt` text,
  `url` text NOT NULL,
  `hashed_url` varchar(64) NOT NULL,
  `blog_name` varchar(255) default NULL,
  `ip_address` varchar(64) default NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_article` (`ref_article`),
  KEY `modified` (`modified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_blg_blog`
-- 

CREATE TABLE `sns_blg_blog` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `type` int(11) default NULL,
  `url` varchar(255) default NULL,
  `rss` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_blg_comment`
-- 

CREATE TABLE `sns_blg_comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_entry` int(11) NOT NULL,
  `ref_author` int(11) NOT NULL,
  `flag` int(11) default '0',
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `ref_entry` (`ref_entry`),
  KEY `regist_date` (`regist_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_blg_entry`
-- 

CREATE TABLE `sns_blg_entry` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_account` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `format` int(11) NOT NULL,
  `posts` int(11) default '0',
  `link` varchar(255) default NULL,
  `tb_url` varchar(255) default NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `tag` text,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `regist_date` (`regist_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_blg_keyword`
-- 

CREATE TABLE `sns_blg_keyword` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_entry` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `tag` varchar(128) NOT NULL,
  `posts` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_entry` (`ref_entry`),
  KEY `ref_account` (`ref_account`),
  KEY `tag` (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_blg_sendtb`
-- 

CREATE TABLE `sns_blg_sendtb` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `ref_entry` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `url` text NOT NULL,
  `hashed_url` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ref_entry` (`ref_entry`,`hashed_url`),
  KEY `modified` (`modified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_blg_tag`
-- 

CREATE TABLE `sns_blg_tag` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_entry` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `tag` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ref_entry` (`ref_entry`,`tag`),
  KEY `tag` (`tag`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_blg_trackback`
-- 

CREATE TABLE `sns_blg_trackback` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `ref_entry` int(11) NOT NULL,
  `ref_author` int(11) default '0',
  `flag` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `excerpt` text,
  `url` text NOT NULL,
  `hashed_url` varchar(64) NOT NULL,
  `blog_name` varchar(255) default NULL,
  `ip_address` varchar(64) default NULL,
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `ref_account` (`ref_account`),
  KEY `ref_entry` (`ref_entry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_cal_comment`
-- 

CREATE TABLE `sns_cal_comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_schedule` int(11) NOT NULL,
  `ref_author` int(11) NOT NULL,
  `flag` int(11) default '0',
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_schedule` (`ref_schedule`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_cal_schedule`
-- 

CREATE TABLE `sns_cal_schedule` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `visibility` int(11) NOT NULL default '1',
  `schedule` varchar(255) NOT NULL,
  `start_date` date default NULL,
  `end_date` date default NULL,
  `start_hour` varchar(4) default NULL,
  `start_minute` varchar(4) default NULL,
  `end_hour` varchar(4) default NULL,
  `end_minute` varchar(4) default NULL,
  `comment` text,
  `reminder` int(11) default NULL,
  `posts` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `start_date` (`start_date`),
  KEY `end_date` (`end_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_cnt_category`
-- 

CREATE TABLE `sns_cnt_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `category` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_cnt_contact`
-- 

CREATE TABLE `sns_cnt_contact` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_category` int(11) default NULL,
  `ref_account` int(11) default NULL,
  `status` int(11) NOT NULL,
  `flag` int(11) default '0',
  `name` varchar(128) NOT NULL,
  `url` varchar(128) default NULL,
  `email` blob,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_category` (`ref_category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_cnt_response`
-- 

CREATE TABLE `sns_cnt_response` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_contact` int(11) default NULL,
  `ref_account` int(11) NOT NULL,
  `send` int(11) default NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_contact` (`ref_contact`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_article`
-- 

CREATE TABLE `sns_com_article` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_community` int(11) NOT NULL,
  `ref_author` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `article` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  `posts` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_community` (`ref_community`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_attend`
-- 

CREATE TABLE `sns_com_attend` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_community` int(11) NOT NULL,
  `ref_event` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ref_event` (`ref_event`,`ref_account`),
  KEY `ref_account` (`ref_account`),
  KEY `ref_community` (`ref_community`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_category`
-- 

CREATE TABLE `sns_com_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_genre` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `category` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_genre` (`ref_genre`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_comment`
-- 

CREATE TABLE `sns_com_comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_community` int(11) NOT NULL,
  `ref_topic` int(11) NOT NULL,
  `ref_author` int(11) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_community` (`ref_community`),
  KEY `ref_topic` (`ref_topic`),
  KEY `ref_author` (`ref_author`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_community`
-- 

CREATE TABLE `sns_com_community` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_account` int(11) NOT NULL,
  `avail` int(11) NOT NULL default '1',
  `community` varchar(128) NOT NULL,
  `ref_category` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `involved` int(11) NOT NULL,
  `topic_flag` int(11) NOT NULL,
  `event_flag` int(11) NOT NULL,
  `article_flag` int(11) NOT NULL,
  `ref_region` int(11) NOT NULL,
  `comment` text NOT NULL,
  `member_num` int(11) default '0',
  `access_num` int(11) default '0',
  `filename` varchar(255) default NULL,
  `width` int(11) default '0',
  `height` int(11) default '0',
  `thumbnail` varchar(255) default NULL,
  `t_width` int(11) default '0',
  `t_height` int(11) default '0',
  `v_small` varchar(255) default NULL,
  `v_width` int(11) default NULL,
  `v_height` int(11) default NULL,
  `ref_theme` int(11) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `community` (`community`),
  KEY `member_num` (`member_num`),
  KEY `ref_category` (`ref_category`),
  KEY `access_num` (`access_num`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_event`
-- 

CREATE TABLE `sns_com_event` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL,
  `ref_community` int(11) NOT NULL,
  `ref_author` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `deadline` date default NULL,
  `start_hour` varchar(4) default NULL,
  `start_minute` varchar(4) default NULL,
  `ref_region` int(11) NOT NULL,
  `ref_city` int(11) default NULL,
  `locale` varchar(255) default NULL,
  `event` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  `posts` int(11) NOT NULL default '0',
  `entries` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `start_date` (`start_date`),
  KEY `ref_region` (`ref_region`),
  KEY `entries` (`entries`),
  KEY `deadline` (`deadline`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_genre`
-- 

CREATE TABLE `sns_com_genre` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `genre` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_names`
-- 

CREATE TABLE `sns_com_names` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_community` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `bulletin` int(11) NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  KEY `ref_community` (`ref_community`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_report`
-- 

CREATE TABLE `sns_com_report` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_community` int(11) NOT NULL,
  `ref_event` int(11) NOT NULL,
  `ref_author` int(11) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_community` (`ref_community`),
  KEY `ref_event` (`ref_event`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_topic`
-- 

CREATE TABLE `sns_com_topic` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_community` int(11) NOT NULL,
  `ref_author` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  `posts` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_community` (`ref_community`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_com_trackback`
-- 

CREATE TABLE `sns_com_trackback` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `ref_community` int(11) NOT NULL,
  `ref_article` int(11) NOT NULL,
  `ref_author` int(11) default '0',
  `flag` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `excerpt` text,
  `url` text NOT NULL,
  `hashed_url` varchar(64) NOT NULL,
  `blog_name` varchar(255) default NULL,
  `ip_address` varchar(64) default NULL,
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `ref_community` (`ref_community`),
  KEY `ref_article` (`ref_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_des_theme`
-- 

CREATE TABLE `sns_des_theme` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ref_author` int(11) NOT NULL,
  `theme` varchar(128) NOT NULL,
  `body` varchar(6) NOT NULL,
  `text` varchar(6) NOT NULL,
  `bold` varchar(6) NOT NULL,
  `border` varchar(6) NOT NULL,
  `header` varchar(6) NOT NULL,
  `bg_column` varchar(6) NOT NULL,
  `bg_header` varchar(6) NOT NULL,
  `bg_data` varchar(6) NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_fav_favorite`
-- 

CREATE TABLE `sns_fav_favorite` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `target` int(11) NOT NULL,
  `ref_target` int(11) NOT NULL,
  `tag` text,
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_fav_tag`
-- 

CREATE TABLE `sns_fav_tag` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_favorite` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `tag` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ref_favorite` (`ref_favorite`,`tag`),
  KEY `tag` (`tag`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_fri_comment`
-- 

CREATE TABLE `sns_fri_comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  `relation` varchar(128) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ref_account` (`ref_account`),
  KEY `ref_friend` (`ref_friend`),
  KEY `modified` (`modified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_fri_friends`
-- 

CREATE TABLE `sns_fri_friends` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `status` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ref_account` (`ref_account`,`ref_friend`),
  KEY `ref_friend` (`ref_friend`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_fri_invite`
-- 

CREATE TABLE `sns_fri_invite` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) default NULL,
  `email` blob NOT NULL,
  `hashed_email` varchar(40) default NULL,
  `comment` text,
  `display` int(11) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `ref_account` (`ref_account`),
  KEY `hashed_email` (`hashed_email`),
  KEY `ref_friend` (`ref_friend`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_fri_message`
-- 

CREATE TABLE `sns_fri_message` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` int(11) default '1',
  `ref_origin` int(11) NOT NULL default '0',
  `ref_account` int(11) NOT NULL,
  `ref_to` int(11) NOT NULL,
  `ref_from` int(11) NOT NULL,
  `ref_message` int(11) default '0',
  `flag` int(11) default '1',
  `subject` varchar(128) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_log_access`
-- 

CREATE TABLE `sns_log_access` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `target` int(11) NOT NULL,
  `ref_target` int(11) NOT NULL,
  `ref_audience` int(11) default NULL,
  `unique_flag` int(11) NOT NULL,
  `url` text NOT NULL,
  `referrer` text NOT NULL,
  `ip_address` varchar(128) NOT NULL,
  `agent` varchar(128) NOT NULL,
  `ismobile` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `ref_target` (`ref_target`),
  KEY `ref_audience` (`ref_audience`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_log_footprint`
-- 

CREATE TABLE `sns_log_footprint` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `target` int(11) NOT NULL,
  `ref_target` int(11) NOT NULL,
  `ref_audience` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `target` (`target`,`ref_target`),
  KEY `ref_audience` (`ref_audience`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_rev_category`
-- 

CREATE TABLE `sns_rev_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `service` varchar(16) NOT NULL,
  `code` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_rev_rating`
-- 

CREATE TABLE `sns_rev_rating` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `item_code` varchar(64) default NULL,
  `ref_account` int(11) NOT NULL,
  `point` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_code` (`item_code`,`ref_account`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_rev_review`
-- 

CREATE TABLE `sns_rev_review` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `item_code` varchar(64) NOT NULL,
  `total` float default '0',
  `posts` int(11) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_code` (`item_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_rev_trackback`
-- 

CREATE TABLE `sns_rev_trackback` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `item_code` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `excerpt` text,
  `url` text NOT NULL,
  `hashed_url` varchar(64) NOT NULL,
  `blog_name` varchar(255) default NULL,
  `ip_address` varchar(64) default NULL,
  PRIMARY KEY  (`id`),
  KEY `modified` (`modified`),
  KEY `item_code` (`item_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_rss_feed`
-- 

CREATE TABLE `sns_rss_feed` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `title` varchar(255) NOT NULL,
  `link` text NOT NULL,
  `hashed_url` varchar(40) NOT NULL,
  `url` text,
  `articles` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `hashed_url` (`hashed_url`),
  KEY `modified` (`modified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sum_answer`
-- 

CREATE TABLE `sns_sum_answer` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ref_poll` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `answer` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ref_poll` (`ref_poll`,`ref_account`),
  KEY `modified` (`modified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sum_poll`
-- 

CREATE TABLE `sns_sum_poll` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL,
  `code` varchar(40) NOT NULL,
  `deadline` date default NULL,
  `ref_account` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `poll` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  `answers` text NOT NULL,
  `posts` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `regist_date` (`regist_date`),
  KEY `deadline` (`deadline`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sum_rating`
-- 

CREATE TABLE `sns_sum_rating` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `item_code` varchar(64) default NULL,
  `ref_account` int(11) NOT NULL,
  `point` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_code` (`item_code`,`ref_account`),
  KEY `ref_account` (`ref_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sys_blob`
-- 

CREATE TABLE `sns_sys_blob` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` timestamp NOT NULL default '0000-00-00 00:00:00',
  `origin` varchar(40) NOT NULL,
  `name` varchar(128) NOT NULL,
  `mime_type` varchar(128) NOT NULL,
  `uid` int(11) NOT NULL,
  `gid` int(11) NOT NULL,
  `size` int(11) NOT NULL,
  `buffer` mediumblob NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `origin` (`origin`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sys_message`
-- 

CREATE TABLE `sns_sys_message` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `regist_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` int(11) NOT NULL default '4',
  `subject` varchar(255) NOT NULL,
  `send_type` int(11) NOT NULL default '1',
  `body` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `regist_date` (`regist_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sys_msgtpl`
-- 

CREATE TABLE `sns_sys_msgtpl` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `language` varchar(8) NOT NULL,
  `code` varchar(128) NOT NULL,
  `subject` varchar(128) NOT NULL,
  `email` varchar(128) NOT NULL,
  `name` varchar(128) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `language` (`language`,`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sys_sessions`
-- 

CREATE TABLE `sns_sys_sessions` (
  `id` varchar(128) NOT NULL,
  `life_time` int(11) unsigned default NULL,
  `sess_data` text,
  PRIMARY KEY  (`id`),
  KEY `life_time` (`life_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- テーブルの構造 `sns_sys_sponsor`
-- 

CREATE TABLE `sns_sys_sponsor` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `status` int(11) NOT NULL default '0',
  `position` int(11) NOT NULL,
  `sponsor` varchar(128) NOT NULL,
  `html` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
