<?php
/* SVN FILE: $Id: rkt_model.php 280 2008-05-07 22:22:56Z bb_yujiro $ */
/**
 * Modelクラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 280 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:22:56 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Modelクラス
 *
 * @category        Model
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 280 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:22:56 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_Model
{
    /**
     * 操作の種類:何もしない
     * @const integer
     */
    const QUERY_NONE = 0;

    /**
     * 操作の種類:挿入
     * @const integer
     */
    const QUERY_INSERT = 1;

    /**
     * 操作の種類:更新
     * @const integer
     */
    const QUERY_UPDATE = 2;

    /**
     * 操作の種類:参照
     * @const integer
     */
    const QUERY_SELECT = 3;

    /**
     * 操作の種類:削除
     * @const integer
     */
    const QUERY_DELETE = 4;

    /**
     * 入力方法:ダイレクト
     * @const integer
     */
    const INPUT_DIRECT = 1;

    /**
     * 入力方法:キャッチ
     * @const integer
     */
    const INPUT_CHATCH = 2;

    /**
     * 条件指定
     * @const boolean
     */
    const CONDITION = true;

    /**
     * Validateオジェクト
     * @var object
     */
    public $objrqt = null;

    /**
     * DB接続オブジェクト
     * @var object
     */
    protected $objdb = null;

    /**
     * ステートメントオブジェクト
     * @var object
     */
    protected $objstmt = null;

    /**
     * アクションフラグ
     * @var integer
     */
    protected $action_flag = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $tbl_name テーブル名
     */
    public function __construct()
    {
        $this->objdb  = RKT_DB::getInstance();
        $this->objrqt = RKT_Request::getInstance();
        $this->initValue();
    }

    /**
     * 入力内容の取得
     *
     * @access public
     * @return void
     */
    public function catchRequest()
    {
        foreach ($this->column as $key=>$column){
            if ($this->objrqt->catchValidate($key, $column)){
                $this->$key = $this->objrqt->getRequest($key);
            }
        } // foreach ($this->column as $key=>$column)
    }

    /**
     * テーブルリストの取得
     *
     * @access public
     * @param string $table
     * @param string $order
     * @param mixed $condition
     * @return array
     */
    public function getReferenceList($table, $order='sort', $condition=null)
    {
        /* 項目の取得 */
        $pos = strpos($table, '_');
        if ($pos === false){
            $column = 'label';        
        } else {
            $column = substr($table, $pos+1);
        }

        /* WHERE句の作成 */
        $where  = '';
        $wheres = array();
        if (is_array($condition)){
            foreach ($condition as $key=> $value){
                $wheres[] = $key.' = '.$this->objdb->quote($value);
            }
            $where = 'WHERE '. implode(' AND ', $wheres) .' ';
        }

        $list = array();
        $sql =
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.$table.' '.
            $where.
            'ORDER BY '.
                $order;
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($result)){
            return $list;
        }
        foreach ($result as $row){
            $list[$row['id']] = $row[$column];
        }
        return $list;
    }

    /**
     * 参照テーブル名の取得
     *
     * @access public
     * @return array
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * アクションフラグの取得
     *
     * @access public
     * @return integer カレントID
     */
    public function getActionFlag()
    {
        return $this->action_flag;
    }

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
    }
} // class RKT_Model
?>
