<?php
/* SVN FILE: $Id: rkt_exception.php 231 2008-05-02 18:55:05Z bb_yujiro $ */
/**
 * 例外処理設定
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 231 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:55:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Exceptionクラス
 *
 * @category        hitSuji Core
 * @package         hitSuji
 * @copyright       Copyright (c) 2008 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 231 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:55:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_Exception extends Exception
{
    /**
     * 不明なエラー
     * @const integer
     */
    const UNKNOWN_ERROR = 1;

    /**
     * アクセス拒否
     * @const integer
     */
    const ACCESS_DENIED = 2;

    /**
     * 権限拒否
     * @const integer
     */
    const PERMISSION_DENIED = 3;

    /**
     * 悪意あるユーザー
     * @const integer
     */
    const MALICIOUS_USER = 4;

    /**
     * 無効な要求
     * @const integer
     */
    const BAD_REQUEST = 5;

    /**
     * 存在していない
     * @const integer
     */
    const NOT_FOUND = 6;

    /**
     * コンストラクタ
     *
     * Example:
     * <code>
     * if ($is_error){
     *     throw new RKT_Exception(RKT_Exception::UNKNOWN_ERROR);
     * }
     * </code>
     *
     * @access public
     * @param integer $code エラーコード
     */
    public function __construct($code = self::UNKNOWN_ERROR)
    {
        $message = array(
            self::UNKNOWN_ERROR=>     'Unknown error.',
            self::ACCESS_DENIED=>     'Access denied.',
            self::PERMISSION_DENIED=> 'Permission denied.',
            self::MALICIOUS_USER=>    'Malicious user.',
            self::BAD_REQUEST=>       'Bad request.',
            self::NOT_FOUND=>         'Not found.',
        );
    
        parent::__construct($message[$code], $code);
    }
} // RKT_Exception
?>
