<?php
/* SVN FILE: $Id: rkt_blob.php 246 2008-05-03 20:32:15Z bb_yujiro $ */
/**
 * バイナリデータ管理クラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 246 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-04 05:32:15 +0900 (日, 04 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktBlob/Common.php';

/**
 * バイナリデータ管理クラス
 *
 * @category        Binary Large OBject
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 246 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-04 05:32:15 +0900 (日, 04 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_Blob
{
    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @return PDO object
     *
     * RKT_Blob::exec()->getBuffer();
     *
     */
    public static function exec()
    {
        if (isset(self::$_instance)) {
            return self::$_instance;
        }
        return self::getInstance();
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return object __CLASS__
     */
    public static function getInstance($driver=BLOB_DRIVER, $param=BLOB_PARAM)
    {
        if (!isset(self::$_instance)) {
            self::$_instance = self::factory($driver, $param);
        }

        return self::$_instance;
    }

    /**
     * Factory メソッド
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return void
     */
    public static function factory($driver, $param)
    {
        if (include LIB_DIR.'rktBlob/'.$driver.'.php') {
            $classname = 'BLOB_'.$driver;
            return new $classname($param);
        } else {
            throw new Exception ('Driver not found');
        }
    }
} // RKT_image
?>
