<?php
/* SVN FILE: $Id: Theme.php 382 2008-05-15 02:38:40Z bb_yujiro $ */
/**
 * Theme設定
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 382 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:38:40 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Themeクラス
 *
 * @category        View
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 382 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:38:40 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Theme
{
    /**
     * 画面の横幅
     * @const integer
     */
    const WIDTH = 240;

    /**
     * フォントサイズ
     * @const integer
     */
    const FONT_SIZE = 1;

    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * テーマID
     * @var integer
     */
    protected static $theme_id;

    /**
     * テーマ情報
     * @var array
     */
    private $_theme = null;

    /**
     * スイッチ
     * @var integer
     */
    private $_switch = 0;

    /**
     * コンストラクタ
     *
     * @access public
     */
    private function __construct()
    {
        $id = self::Id();

        $this->_theme = RKT_DB::getRow('des_theme', $id);
    }

    /**
     * 実行処理スタテック版
     *
     * @access public
     * @return object
     *
     * Example:
     * <code>
     * Theme::exec()->fontColor();
     * </code>
     *
     */
    public static function exec()
    {
        if (!isset(self::$_instance)) {
            $classname = __CLASS__;
            self::$_instance = new $classname();
        }
        return self::$_instance;
    }

    /**
     * テーマIDの設定と取得
     *
     * @access public
     * @param integer $id
     * @return integer
     */
    public static function Id($id=null)
    {
        if ($id != null){
            self::$theme_id = $id;
        }
        return self::$theme_id;
    }

    /**
     * テーマパスの出力
     *
     * @access public
     * @param integer $id
     * @return integer
     */
    public static function Path()
    {
        print (BASE_URL.ARCHIVES_THEME_PATH.Theme::Id().'/');
    }

    /**
     * 警告カラーの出力
     *
     * @access public
     * @return void
     */
    public function alertColor()
    {
        print ('#FF0000');
    }

    /**
     * フォントサイズ出力
     *
     * @access public
     * @return void
     */
    public function fontSize()
    {
        print (self::FONT_SIZE);
    }

    /**
     * カラーの出力
     *
     * @access public
     * @return void
     */
    public function fontColor()
    {
        print ('#'.$this->_theme['text']);
    }

    /**
     * カラーの出力
     *
     * @access public
     * @return void
     */
    public function columnColor()
    {
        print ('#'.$this->_theme['bold']);
    }

    /**
     * カラーの出力
     *
     * @access public
     * @return void
     */
    public function titleColor()
    {
        print ('#'.$this->_theme['header']);
    }

    /**
     * カラーの出力
     *
     * @access public
     * @return void
     */
    public function borderColor()
    {
        print ('#'.$this->_theme['border']);
    }

    /**
     * カラーの出力
     *
     * @access public
     * @return void
     */
    public function bgColor()
    {
        $switch  = array (0=>1, 1=>0);
        $num2key = array (0=>'body', 1=>'bg_data');
        
        print ('#'.$this->_theme[$num2key[$this->_switch]]);
        $this->_switch = $switch[$this->_switch];
    }

    /**
     * カラーの出力
     *
     * @access public
     * @return void
     */
    public function bgColumnColor()
    {
        print ('#'.$this->_theme['bg_column']);
    }

    /**
     * カラーの出力
     *
     * @access public
     * @return void
     */
    public function bgTitleColor()
    {
        print ('#'.$this->_theme['bg_header']);
    }

    /**
     * 横幅の出力
     *
     * @access public
     * @return void
     */
    public function mainWidth()
    {
        print (self::WIDTH);
    }
} // Theme
?>
