<?php
/* SVN FILE: $Id: Common.php 328 2008-05-11 01:10:11Z bb_yujiro $ */
/**
 * 形態素解析（Morphological Analysis）
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 328 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:10:11 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Text_MA_Commonクラス
 *
 * @category        Morphological Analysis
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 328 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:10:11 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_MA_Common
{
    /**
     * 形容詞
     * @const string
     */
    const FILTER_ADJECTIVE       = '1';

    /**
     * 形容動詞
     * @const string
     */
    const FILTER_ADJECTIVAL_NOUN = '2';

    /**
     * 感動詞
     * @const string
     */
    const FILTER_EXCLAMATION     = '3';

    /**
     * 副詞
     * @const string
     */
    const FILTER_ADVERB          = '4';

    /**
     * 連体詞
     * @const string
     */
    const FILTER_ADNOMINAL       = '5';

    /**
     * 接続詞
     * @const string
     */
    const FILTER_CONJUNCTION     = '6';

    /**
     * 接頭辞
     * @const string
     */
    const FILTER_PREFIX          = '7';

    /**
     * 接尾辞
     * @const string
     */
    const FILTER_SUFFIX          = '8';

    /**
     * 名詞
     * @const string
     */
    const FILTER_NOUN            = '9';

    /**
     * 動詞
     * @const string
     */
    const FILTER_VERB            = '10';

    /**
     * 助詞
     * @const string
     */
    const FILTER_PARTICLE        = '11';

    /**
     * 助動詞
     * @const string
     */
    const FILTER_AUXILIARY_VERB  = '12';

    /**
     * 特殊
     * @const string
     */
    const FILTER_SPECIAL         = '13';

    /**
     * 解析結果の単語数
     * @var integer
     */
    protected $total;

    /**
     * 解析結果
     * @var array
     */
    protected $parsed = array();

    /**
     * 解析対象のテキスト
     * @var string
     */
    protected $sentence;

    /**
     * 品詞番号
     * @var string
     */
    protected $filter;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    protected function __construct()
    {
        $this->filter = self::FILTER_NOUN;
    }

    /**
     * 解析結果の取得
     *
     * @access public
     * @return string
     **/
    public function getParsed()
    {
        return $this->parsed;
    }

    /**
     * 解析対象の設定
     *
     * @access public
     * @param string $sentence
     * @return void
     **/
    public function setSentence($sentence)
    {
        $this->sentence = $sentence;
    }

    /**
     * 出力する品詞番号の設定
     *
     * @access public
     * @param string $filter
     * @return void
     **/
    public function setFilter($filter)
    {
        $this->filter = $filter;
    }
} // class Text_MA_Common
?>
