<?php
/* SVN FILE: $Id: MA.php 328 2008-05-11 01:10:11Z bb_yujiro $ */
/**
 * 形態素解析（Morphological Analysis）
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 328 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:10:11 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktText/MA/Common.php';

/**
 * Text_MAクラス
 *
 * @category        Morphological Analysis
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 328 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:10:11 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_MA
{
    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @param string $driver
     * @return object __CLASS__
     */
    public static function getInstance($driver='Yahoo')
    {
        if (!isset(self::$_instance)) {
            self::$_instance = self::factory($driver);
        }

        return self::$_instance;
    }

    /**
     * Factory メソッド
     *
     * @access public
     * @param string $driver
     * @return void
     */
    public static function factory($driver)
    {
        if (include LIB_DIR.'rktText/MA/'.$driver.'.php') {
            $classname = 'Text_MA_'.$driver;
            return new $classname();
        } else {
            throw new Exception ('Driver not found');
        }
    }
} // class Text_MA
?>
