<?php
/* SVN FILE: $Id: Mail.php 479 2008-05-23 16:36:27Z bb_yujiro $ */
/**
 * 独自タグ用絵文字変換
 *
 * 参考資料：
 *       [絵文字の相互変換リスト] http://labs.unoh.net/2007/02/post_65.html
 *       [ケータイに絵文字入りメールを送信するには] 
 *              http://ke-tai.org/blog/2007/11/15/emojimail_i/
 *              http://ke-tai.org/blog/2007/11/16/emojimail_au/
 *              http://ke-tai.org/blog/2007/11/17/emojimail_sb/
 *
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 独自タグ用絵文字変換
 *
 * @category        Emoji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_Emoji_Tag
{
    /**
     * Imgタグから独自タグへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2tag($dec)
    {
        return '[m:'.$dec.']';
    }

    /**
     * タグから独自Imgタグへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2img($dec)
    {
        return '<img src="'.BASE_URL.'resource/img/emoji/'.$dec.'.gif">';
    }

    /**
     * 独自タグからShift_JIS DoCoMoへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2docomo($dec)
    {
        $map = array(
              '1'=>'F9DC',                            '2'=>'F9A7',            '3'=>'8148',              '4'=>'F986',            '5'=>'3c',
              '6'=>'3e',                              '7'=>'3c3c',                  '8'=>'3e3e',              '9'=>'81a1',                 '10'=>'81a1',
             '11'=>'5b695d',                         '12'=>'F9FB',           '13'=>'5b83588373815b834a5d',     '14'=>'F9BA',           '15'=>'F943',
             '16'=>'F8A3',                           '17'=>'81a1',                 '18'=>'81a1',             '19'=>'819f',                 '20'=>'819f',
             '21'=>'81a1',                           '22'=>'81a1',                 '23'=>'F940',       '24'=>'F940',           '25'=>'F9C4',
             '26'=>'817b',                           '27'=>'817c',                 '28'=>'8196',             '29'=>'81aa',                 '30'=>'81ab',
             '31'=>'F9DD',                           '32'=>'81a5',                 '33'=>'81a3',             '34'=>'81a5',                 '35'=>'81a3',
             '36'=>'819f',                           '37'=>'819f',                 '38'=>'81a1',             '39'=>'81a1',                 '40'=>'F940',
             '41'=>'F940',                           '42'=>'F8F8',           '43'=>'F8F7',       '44'=>'F89F',           '45'=>'F8B4',
             '46'=>'F95E',                           '47'=>'F942',           '48'=>'F9B8',       '49'=>'83d3',                 '50'=>'F995',
             '51'=>'F991',                           '52'=>'F8D2',           '53'=>'F9E6',       '54'=>'F9D7',           '55'=>'817e',
             '56'=>'F8EA',                           '57'=>'F9C1',           '58'=>'F9C1',       '59'=>'5b8374838d83628373815b5d',       '60'=>'5b90e18c8b8fbb5d',
             '61'=>'817e',                           '62'=>'817e',                 '63'=>'81a8',             '64'=>'81a9',                 '65'=>'F8D3',
             '66'=>'8180',                           '67'=>'5b834a838c8393835f815b5d',       '68'=>'F995',       '69'=>'8199',                 '70'=>'F8D9',
             '71'=>'F949',                           '72'=>'F9C0',           '73'=>'5b836083468362834e5d',     '74'=>'F945',           '75'=>'81999c63',
             '76'=>'F99F',                           '77'=>'F9A0',           '78'=>'F9F4',       '79'=>'5b83748348838b835f5d',         '80'=>'F995',
             '81'=>'F9D6',                           '82'=>'F9DB',           '83'=>'F8E3',       '84'=>'5b83748348838b835f5d',         '85'=>'F8E8',
             '86'=>'5b8374834c835f83565d',           '87'=>'5b834a815b83685d',           '88'=>'81a3',             '89'=>'81a5',                 '90'=>'5b5553415d',
             '91'=>'F8E4',                           '92'=>'F8EA',           '93'=>'F8D1',       '94'=>'F8E2',           '95'=>'F8A1',
             '96'=>'5b837483628367837b815b838b5d',   '97'=>'F8E4',           '98'=>'F9D4',       '99'=>'F8CE',          '100'=>'F8E4',
            '101'=>'F8E4',                          '102'=>'F8E4',          '103'=>'F8EA',      '104'=>'F8D6',          '105'=>'5b834a838c8393835f815b5d',
            '106'=>'F8DF',                          '107'=>'F8A0',          '108'=>'F977',      '109'=>'F97A',          '110'=>'F8D8',
            '111'=>'F8D8',                          '112'=>'F8C4',          '113'=>'F9E8',      '114'=>'5b95ef929a5d',            '115'=>'5b8372836683495d',
            '116'=>'F8FB',                          '117'=>'84a481a8',              '118'=>'F97E',      '119'=>'F981',          '120'=>'F97D',
            '121'=>'F8E4',                          '122'=>'F8E4',          '123'=>'5b836c83575d',        '124'=>'F8D5',          '125'=>'F8BF',
            '126'=>'5b8374838d83628373815b5d',      '127'=>'5b834f838983745d',          '128'=>'5b834f838983745d',      '129'=>'F8C6',          '130'=>'F9A0',
            '131'=>'F8E4',                          '132'=>'5b836083468362834e837d815b834e5d',  '133'=>'F9EC',      '134'=>'F945',          '135'=>'5b936492725d',
            '136'=>'F9AF',                          '137'=>'5b89e682d182e582a45d',        '138'=>'F97D',      '139'=>'F9BA',          '140'=>'81a9',
            '141'=>'81a8',                          '142'=>'F8E4',          '143'=>'F9D5',      '144'=>'F8E6',          '145'=>'5b96bc8e445d',
            '146'=>'F8D0',                          '147'=>'F8E4',          '148'=>'5b836783898362834e5d',    '149'=>'F9BE',          '150'=>'5b5044435d',
            '151'=>'F973',                          '152'=>'F9BD',          '153'=>'5b9197904d424f585d',     '154'=>'5b8ef3904d424f585d',         '155'=>'F8E8',
            '156'=>'F8C5',                          '157'=>'5b92e88b4b5d',            '158'=>'5b8e4f8a7092e88b4b5d',    '159'=>'5b834f838983745d',          '160'=>'5b93f75d',
            '161'=>'F8E9',                          '162'=>'5b83528393835a839383675d',      '163'=>'5b89c691b05d',        '164'=>'5b838a8393834e5d',          '165'=>'F8E6',
            '166'=>'F974',                          '167'=>'2569312525693225',          '168'=>'F8C3',      '169'=>'F947',          '170'=>'5b835483438352838d5d',
            '171'=>'5b905695b75d',                  '172'=>'F8BC',          '173'=>'8140',            '174'=>'',                  '175'=>'',
            '176'=>'F8E0',                          '177'=>'F8E1',          '178'=>'F8FC',      '179'=>'5b8ee19774837d815b834e5d',      '180'=>'F987',
            '181'=>'F988',                          '182'=>'F989',          '183'=>'F98A',      '184'=>'F98B',          '185'=>'F98C',
            '186'=>'F98D',                          '187'=>'F98E',          '188'=>'F98F',      '189'=>'5b31305d',              '190'=>'F8A4',
            '191'=>'F8A2',                          '192'=>'F8A7',          '193'=>'F8A8',      '194'=>'F8A9',          '195'=>'F8AA',
            '196'=>'F8AB',                          '197'=>'F8AC',          '198'=>'F8AD',      '199'=>'F8AE',          '200'=>'F8AF',
            '201'=>'F8B0',                          '202'=>'F8B1',          '203'=>'F8B2',      '204'=>'5b8ed68e678dc05d',          '205'=>'F8C9',
            '206'=>'F8CB',                          '207'=>'F8CF',          '208'=>'F8CD',      '209'=>'5b836f835892e25d',          '210'=>'5b83418393836583695d',
            '211'=>'F8C2',                          '212'=>'F8C8',          '213'=>'F8CC',      '214'=>'5b926e907d5d',            '215'=>'F9C2',
            '216'=>'F8C1',                          '217'=>'F8BE',          '218'=>'F9D8',      '219'=>'F8B7',          '220'=>'F8B6',
            '221'=>'F9B7',                          '222'=>'F8BA',          '223'=>'5b8acf97978ed45d',      '224'=>'F99C',          '225'=>'F9F0',
            '226'=>'F950',                          '227'=>'F957',          '228'=>'5b938c8b9e835e838f815b5d',  '229'=>'5b3737375d',             '230'=>'5b834983818366836783455d',
            '231'=>'5b934992865d',                  '232'=>'F8EC',          '233'=>'F9BA',      '234'=>'F948',          '235'=>'F9ED',
            '236'=>'5b82a889bb82af5d',              '237'=>'5b93fa82cc8adb5d',          '238'=>'5b83588343834a5d',      '239'=>'F9EF',          '240'=>'5b837483898343837083935d',
            '241'=>'F9E7',                          '242'=>'F9F6',          '243'=>'5b8343836083535d',      '244'=>'F9EE',          '245'=>'F8D4',
            '246'=>'5b834e835783895d',              '247'=>'5b83458354834d5d',          '248'=>'F9F9',      '249'=>'5b8354838b5d',            '250'=>'5b834a8347838b5d',
            '251'=>'F946',                          '252'=>'F9F5',          '253'=>'5b8341838a5d',        '254'=>'F9FA',          '255'=>'5b8372815b83605d',
            '256'=>'5b82d082dc82ed82e85d',          '257'=>'F995',          '258'=>'F996',      '259'=>'F9D2',          '260'=>'F9D0',
            '261'=>'F9A6',                          '262'=>'F9A1',          '263'=>'F9AC',      '264'=>'F9CD',          '265'=>'F993',
            '266'=>'F994',                          '267'=>'F99F',          '268'=>'F9A3',      '269'=>'5b898a5d',              '270'=>'5b534f535d',
            '271'=>'5b97cd82b182d45d',              '272'=>'F991',          '273'=>'F99E',      '274'=>'5b89469288906c5d',          '275'=>'F8A4',
            '276'=>'F8F9',                          '277'=>'5b8341834e837d5d',          '278'=>'5b89d48adb5d',        '279'=>'F9D9',          '280'=>'5b313030935f5d',
            '281'=>'F9A2',                          '282'=>'F9AD',          '283'=>'5b8345839383605d',      '284'=>'5b906c8db782b58e775d',        '285'=>'5b93be5d',
            '286'=>'5b8368834e838d5d',              '287'=>'F9CC',          '288'=>'F8EB',      '289'=>'F8D7',          '290'=>'F9B4',
            '291'=>'F9A4',                          '292'=>'5b834d835e815b5d',          '293'=>'5b836f83438349838a83935d',  '294'=>'F8DB',          '295'=>'F9B5',
            '296'=>'5b837383588367838b5d',          '297'=>'5b8347835883655d',          '298'=>'5b455a5d',          '299'=>'F97B',          '300'=>'F8ED',
            '301'=>'F9B3',                          '302'=>'5b55464f5d',             '303'=>'5b5550215d',         '304'=>'5b928d8ecb5d',            '305'=>'F8A5',
            '306'=>'F8B5',                          '307'=>'F8B9',          '308'=>'F8BB',      '309'=>'F8DC',          '310'=>'5b89898c805d',
            '311'=>'F8DE',                          '312'=>'F8E5',          '313'=>'F8E7',      '314'=>'F8EF',          '315'=>'F8F0',
            '316'=>'F8F1',                          '317'=>'F8F2',          '318'=>'F8F3',      '319'=>'F8F5',          '320'=>'F8F6',
            '321'=>'F940',                          '322'=>'F941',          '323'=>'F942',      '324'=>'F980',          '325'=>'F990',
            '326'=>'F9B0',                          '327'=>'F999',          '328'=>'F992',      '329'=>'F9AA',          '330'=>'F9AB',
            '331'=>'5b657a706c75735d',              '332'=>'5b926e8b855d',            '333'=>'F9F1',      '334'=>'F982',          '335'=>'F9B3',
            '336'=>'F8FA',                          '337'=>'F9BB',          '338'=>'5b8389835783495d',      '339'=>'5b836f83895d',            '340'=>'5b8bb389ef5d',
            '341'=>'F8BD',                          '342'=>'F9E5',          '343'=>'F99B',      '344'=>'5b93568e675d',            '345'=>'5b836783895d',
            '346'=>'5b834e837d5d',                  '347'=>'5b836c8359837e5d',          '348'=>'F9CE',      '349'=>'F9CB',          '350'=>'F9FC',
            '351'=>'F9C8',                          '352'=>'5b835e83525d',            '353'=>'5b838d8350836283675d',    '354'=>'F9BF',          '355'=>'F99E',
            '356'=>'5b836e8393837d815b5d',          '357'=>'5b89d489ce5d',            '358'=>'F9EC',      '359'=>'F8E3',          '360'=>'5b95ac90855d',
            '361'=>'5b834c8383839383765d',          '362'=>'5b9683909d5d',            '363'=>'5b56535d',          '364'=>'5b8367838d83748342815b5d',      '365'=>'5b834a83815d',
            '366'=>'5b83588379834383935d',          '367'=>'5b838d835683415d',          '368'=>'5b8d488e9692865d',      '369'=>'F99C',          '370'=>'5b8f6a93fa5d',
            '371'=>'5b975b8fc482af5d',              '372'=>'F9F4',          '373'=>'5b8a9489bf5d',        '374'=>'5b8c788aaf5d',            '375'=>'F8C6',
            '376'=>'F8C7',                          '377'=>'F9E3',          '378'=>'F8CA',      '379'=>'F8C2',          '380'=>'5b31388bd65d',
            '381'=>'5b836f838a335d',                '382'=>'5b434f4f4c5d',            '383'=>'5b8a845d',          '384'=>'5b8354815b837283585d',        '385'=>'F97C',
            '386'=>'F9E0',                          '387'=>'F9DE',          '388'=>'5b8e775d',          '389'=>'5b89635d',              '390'=>'81aa',
            '391'=>'81ab',                          '392'=>'5b90e882a25d',            '393'=>'5b837d8369815b8382815b83685d272c27333934273d3e275b8350815b835e83434f46465d',     '395'=>'F8EA',
            '396'=>'5b836c834e835e83435d',          '397'=>'5b836e834383728358834a83585d',    '398'=>'5b89d491a95d',        '399'=>'5b8354837b836583935d',        '400'=>'F9F0',
            '401'=>'F8D3',                          '402'=>'5b8f6a5d',              '403'=>'5b96f25d',          '404'=>'5b959791445d',            '405'=>'5b834e83898362834a815b5d',
            '406'=>'5b455a836983725d',              '407'=>'5b96588e715d',            '408'=>'5b8375815b83635d',      '409'=>'5b837d836a834c838583415d',      '410'=>'5b94fc976589405d',
            '411'=>'5b8fb089ae5d',                  '412'=>'5b928595a85d',            '413'=>'5b8372834c836a5d',      '414'=>'F8EE',          '415'=>'F991',
            '416'=>'F991',                          '417'=>'F991',          '418'=>'F991',      '419'=>'F991',          '420'=>'F99F',
            '421'=>'F8B8',                          '422'=>'F944',          '423'=>'F9C3',      '424'=>'F9F2',          '425'=>'5b835c83748367834e838a815b83805d',
            '426'=>'5b837c836583675d',              '427'=>'5b82be82f182b25d',          '428'=>'5b82b982f182d782a25d',    '429'=>'F9F1',          '430'=>'5b83708358835e5d',
            '431'=>'5b834a838c815b5d',              '432'=>'5b82a882c582f15d',          '433'=>'5b82b782b55d',        '434'=>'F9EA',          '435'=>'5b82dd82a982f15d',
            '436'=>'5b8367837d83675d',              '437'=>'5b836983585d',            '438'=>'5b95d993965d',        '439'=>'5b93e75d',              '440'=>'F9D1',
            '441'=>'F9C5',                          '442'=>'F9F8',          '443'=>'F9D0',      '444'=>'F998',          '445'=>'F9A6',
            '446'=>'F9C6',                          '447'=>'F9FC',          '448'=>'5b95978ed782d082ab5d',    '449'=>'5b944d5d',              '450'=>'F9CA',
            '451'=>'F999',                          '452'=>'F9C8',          '453'=>'F9A4',      '454'=>'F995',          '455'=>'283e82523c29',
            '456'=>'28814c8252814d29',              '457'=>'5b95405d',              '458'=>'F99E',      '459'=>'283e906c3c29',            '460'=>'5b948f8ee85d',
            '461'=>'F9B0',                          '462'=>'F9A5',          '463'=>'F8F6',      '464'=>'F9D4',          '465'=>'F9B0',
            '466'=>'6d285f205f296d',                '467'=>'F992',          '468'=>'5b836f836a815b5d',      '469'=>'5b8367838983938379836283675d',    '470'=>'5b8372838a8384815b83685d',
            '471'=>'5b9085896a5d',                  '472'=>'5b8fc196688ed45d',          '473'=>'5b8b7e8b7d8ed45d',      '474'=>'5b83708367834a815b5d',        '475'=>'5b83578346836283678352815b8358835e815b5d',
            '476'=>'5b96e58fbc5d',                  '477'=>'5b82d082c88dd582e85d',        '478'=>'5b91b28bc68eae5d',      '479'=>'5b838983938368835a838b5d',      '480'=>'5b82b182a282cc82da82e85d',
            '481'=>'F8A6',                          '482'=>'5b89d489c55d',            '483'=>'5b834a834c95585d',      '484'=>'5b90fc8d8189d489ce5d',        '485'=>'5b8aaa8a4c5d',
            '486'=>'5b959797e95d',                  '487'=>'5b836e838d8345834283935d',      '488'=>'5b82a88c8e8ca95d',      '489'=>'5b83548393835e5d',          '490'=>'F957',
            '491'=>'5b93f85d',                      '492'=>'F8CA',          '493'=>'F89F',      '494'=>'F8DD',          '495'=>'5b83668370815b83675d',
            '496'=>'5b8fe95d',                      '497'=>'5b8fe95d',              '498'=>'5b8d488fea5d',        '499'=>'5b83748389839383585d',        '500'=>'5b8349815b837683938345834683755d',
            '501'=>'5b834a834d5d',                  '502'=>'5b414243445d',            '503'=>'5b616263645d',        '504'=>'5b313233345d',            '505'=>'5b8b4c8d865d',
            '506'=>'5b89c25d',                      '507'=>'5b836083468362834e837d815b834e5d',  '508'=>'F952',      '509'=>'5b838983578349837b835e83935d',    '510'=>'F981',
            '511'=>'5b81a94241434b5d',              '512'=>'5b83758362834e837d815b834e5d',    '513'=>'F972',      '514'=>'F8C4',          '515'=>'F8C6',
            '516'=>'F8EA',                          '517'=>'F97D',          '518'=>'F9DA',      '700'=>'5b8368834383635d',          '701'=>'5b8343835e838a83415d',
            '702'=>'5b8343834d838a83585d',          '703'=>'5b92868d915d',            '704'=>'5b8ad88d915d',        '705'=>'5b9492906c5d',            '706'=>'5b92868d91906c5d',
            '707'=>'5b834383938368906c5d',          '708'=>'5b82a882b682a282b382f15d',      '709'=>'5b82a882ce82a082b382f15d',  '710'=>'5b90d482bf82e182f15d',        '711'=>'5b8d488e968cbb8fea82cc906c5d',
            '712'=>'5b82a89550976c5d',              '713'=>'5b8343838b834a5d',          '714'=>'5b835f839383585d',      '715'=>'F9F6',          '716'=>'5b83518357835183575d',
            '717'=>'5b835d83455d',                  '718'=>'5b8352834183895d',          '719'=>'5b8b8d5d',          '720'=>'5b837783725d',            '721'=>'5b836a838f8367838a5d',
            '722'=>'5b8343836d835683565d',          '723'=>'5b8389834e835f5d',          '724'=>'5b415d',           '725'=>'5b425d',               '726'=>'5b4f5d',
            '727'=>'5b41425d',                      '728'=>'F8F9',          '729'=>'F8FA',      '730'=>'F983',          '731'=>'F99A',
            '732'=>'F9A5',                          '733'=>'F9A8',          '734'=>'F9A9',      '735'=>'F9AF',          '736'=>'5b8381838d83935d',
            '737'=>'5b83708343836983628376838b5d',  '738'=>'5b8375836883455d',          '739'=>'F9E9',      '740'=>'5b82c682a482e082eb82b182b55d',    '741'=>'5b834c836d83525d',
            '742'=>'5b8c495d',                      '743'=>'5b838283825d',            '744'=>'5b82e282ab82a282e05d',    '745'=>'5b837383555d',            '746'=>'5b8360834c83935d',
            '747'=>'5b8eb5975b5d',                  '748'=>'F8D2',          '749'=>'5b92435d',          '750'=>'5b83738341836d5d',          '751'=>'F9B7',
            '752'=>'F9F6',                          '753'=>'5b837b815b838a8393834f5d',      '754'=>'5b82c882dc82cd82b05d',    '755'=>'5b93568be75d',            '756'=>'5b83708393835f5d',
            '757'=>'F9CD',                          '758'=>'F9FA',          '759'=>'5b89d45d',          '760'=>'5b834183438358834e838a815b83805d',  '761'=>'5b8368815b836983635d',
            '762'=>'5b834e8362834c815b5d',          '763'=>'5b8360838783525d',          '764'=>'5b834c83838393836683425d',  '765'=>'5b834c83838393836683425d',      '766'=>'282f5f815f29',
            '767'=>'288145817e814529',              '768'=>'7c288145817e8145297c',        '769'=>'5b89ce8e525d',        '770'=>'F991',          '771'=>'5b4142435d',
            '772'=>'5b8376838a83935d',              '773'=>'5b837e8363836f83605d',        '774'=>'5b82c482f182c682a4928e5d',  '775'=>'5b836e8360837e83635d',        '776'=>'F9EA',
            '777'=>'5b94f282f182c582a282ad8be05d',  '778'=>'5b834e8389834e83895d',        '779'=>'F9C9',      '780'=>'F9C9',          '781'=>'F957',
            '782'=>'28814c8252814d29',              '783'=>'F995',          '784'=>'F973',      '785'=>'F9CF',          '786'=>'F9CF',
            '787'=>'F9CB',                          '788'=>'F998',          '789'=>'F998',      '790'=>'F9D3',          '791'=>'F9D3',
            '792'=>'F9F8',                          '793'=>'5b8368838c83585d',          '794'=>'5b8382834183435d',      '795'=>'5b89775d',              '796'=>'5b89d48e445d',
            '797'=>'5b83578387815b834a815b5d',      '798'=>'5b834783728374838983435d',      '799'=>'F977',      '800'=>'F9D8',          '801'=>'5b83708367834a815b5d',
            '802'=>'5b455a8380815b8372815b5d',      '803'=>'F992',          '804'=>'F9F4',      '805'=>'F9B6',          '806'=>'F9BC',
            '807'=>'F9DA',                          '808'=>'F9E1',          '809'=>'F9E2',      '810'=>'F9E4',          '811'=>'F9EB',
            '812'=>'F9F3',                          '813'=>'F9F8',          '814'=>'F9F8',      '815'=>'5b438381815b838b5d',         '816'=>'F9E6',
            '817'=>'F8F4',                          '818'=>'F985',          '819'=>'285e2d5e292f',        '820'=>'815f285e6f5e29815e',         '821'=>'F998',
            '822'=>'F9C9',
        );
        return empty($map[$dec])?'':pack('H*', $map[$dec]);
    }

    /**
     * 独自タグからMail Shift_JIS EZwebへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2ezweb($dec)
    {
        $map = array(
              '1'=>'753A',      '2'=>'753B',      '3'=>'753C',      '4'=>'7729',      '5'=>'772A',
              '6'=>'772B',      '7'=>'772C',      '8'=>'772D',      '9'=>'772E',     '10'=>'772F',
             '11'=>'7730',     '12'=>'757A',     '13'=>'766C',     '14'=>'7776',     '15'=>'753F',
             '16'=>'7540',     '17'=>'7731',     '18'=>'7732',     '19'=>'7733',     '20'=>'7734',
             '21'=>'7735',     '22'=>'7736',     '23'=>'7737',     '24'=>'7738',     '25'=>'7777',
             '26'=>'7739',     '27'=>'773A',     '28'=>'773B',     '29'=>'773C',     '30'=>'773D',
             '31'=>'773E',     '32'=>'773F',     '33'=>'7740',     '34'=>'7741',     '35'=>'7742',
             '36'=>'7743',     '37'=>'7744',     '38'=>'7745',     '39'=>'7746',     '40'=>'7747',
             '41'=>'7748',     '42'=>'7749',     '43'=>'774A',     '44'=>'7541',     '45'=>'7573',
             '46'=>'7833',     '47'=>'7542',     '48'=>'766D',     '49'=>'775D',     '50'=>'7655',
             '51'=>'7834',     '52'=>'757B',     '53'=>'766E',     '54'=>'774B',     '55'=>'774C',
             '56'=>'775E',     '57'=>'7778',     '58'=>'7535',     '59'=>'775F',     '60'=>'7543',
             '61'=>'774D',     '62'=>'774E',     '63'=>'774F',     '64'=>'7750',     '65'=>'757C',
             '66'=>'7751',     '67'=>'7760',     '68'=>'7656',     '69'=>'7544',     '70'=>'7752',
             '71'=>'7753',     '72'=>'766F',     '73'=>'7754',     '74'=>'763A',     '75'=>'7521',
             '76'=>'7525',     '77'=>'752F',     '78'=>'763B',     '79'=>'782E',     '80'=>'7657',
             '81'=>'7755',     '82'=>'7756',     '83'=>'7555',     '84'=>'782F',     '85'=>'7835',
             '86'=>'7658',     '87'=>'7779',     '88'=>'7757',     '89'=>'7758',     '90'=>'7770',
             '91'=>'7556',     '92'=>'7761',     '93'=>'7836',     '94'=>'7670',     '95'=>'7545',
             '96'=>'7574',     '97'=>'7762',     '98'=>'753D',     '99'=>'7523',    '100'=>'7763',
            '101'=>'7764',    '102'=>'7765',    '103'=>'7766',    '104'=>'7671',    '105'=>'7767',
            '106'=>'7557',    '107'=>'7546',    '108'=>'767C',    '109'=>'777A',    '110'=>'7672',
            '111'=>'777B',    '112'=>'7564',    '113'=>'763F',    '114'=>'777C',    '115'=>'777D',
            '116'=>'7659',    '117'=>'7759',    '118'=>'775A',    '119'=>'7673',    '120'=>'7674',
            '121'=>'7768',    '122'=>'7558',    '123'=>'777E',    '124'=>'7675',    '125'=>'756A',
            '126'=>'7821',    '127'=>'7771',    '128'=>'7772',    '129'=>'7676',    '130'=>'7822',
            '131'=>'7769',    '132'=>'775B',    '133'=>'7629',    '134'=>'763C',    '135'=>'7823',
            '136'=>'775C',    '137'=>'776A',    '138'=>'7677',    '139'=>'7824',    '140'=>'765A',
            '141'=>'765B',    '142'=>'776B',    '143'=>'7559',    '144'=>'762A',    '145'=>'7678',
            '146'=>'7565',    '147'=>'776C',    '148'=>'756B',    '149'=>'755A',    '150'=>'7825',
            '151'=>'7830',    '152'=>'7826',    '153'=>'7831',    '154'=>'7832',    '155'=>'7679',
            '156'=>'7566',    '157'=>'776D',    '158'=>'755B',    '159'=>'7773',    '160'=>'757D',
            '161'=>'7827',    '162'=>'7828',    '163'=>'765C',    '164'=>'7829',    '165'=>'767A',
            '166'=>'767B',    '167'=>'7547',    '168'=>'756C',    '169'=>'756D',    '170'=>'7623',
            '171'=>'782A',    '172'=>'756E',    '173'=>'782B',    '174'=>'782C',    '175'=>'782D',
            '176'=>'7536',    '177'=>'7537',    '178'=>'7538',    '179'=>'7539',    '180'=>'767D',
            '181'=>'767E',    '182'=>'7721',    '183'=>'7722',    '184'=>'7723',    '185'=>'7724',
            '186'=>'7725',    '187'=>'7726',    '188'=>'7727',    '189'=>'7728',    '190'=>'7522',
            '191'=>'753E',    '192'=>'7548',    '193'=>'7549',    '194'=>'754A',    '195'=>'754B',
            '196'=>'754C',    '197'=>'754D',    '198'=>'754E',    '199'=>'754F',    '200'=>'7550',
            '201'=>'7551',    '202'=>'7552',    '203'=>'7553',    '204'=>'7554',    '205'=>'755C',
            '206'=>'755D',    '207'=>'755E',    '208'=>'755F',    '209'=>'7560',    '210'=>'7561',
            '211'=>'7562',    '212'=>'7563',    '213'=>'776E',    '214'=>'776F',    '215'=>'7567',
            '216'=>'7568',    '217'=>'7569',    '218'=>'7524',    '219'=>'756F',    '220'=>'7570',
            '221'=>'7571',    '222'=>'7572',    '223'=>'7526',    '224'=>'7575',    '225'=>'7576',
            '226'=>'7577',    '227'=>'7578',    '228'=>'7579',    '229'=>'7527',    '230'=>'7528',
            '231'=>'757E',    '232'=>'7621',    '233'=>'7622',    '234'=>'7624',    '235'=>'7625',
            '236'=>'7626',    '237'=>'7627',    '238'=>'7628',    '239'=>'762B',    '240'=>'762C',
            '241'=>'762D',    '242'=>'762E',    '243'=>'762F',    '244'=>'7630',    '245'=>'7631',
            '246'=>'7529',    '247'=>'7632',    '248'=>'7633',    '249'=>'7634',    '250'=>'7635',
            '251'=>'7636',    '252'=>'7637',    '253'=>'7638',    '254'=>'7639',    '255'=>'763D',
            '256'=>'763E',    '257'=>'752A',    '258'=>'752B',    '259'=>'752C',    '260'=>'752D',
            '261'=>'752E',    '262'=>'7640',    '263'=>'7641',    '264'=>'7642',    '265'=>'7530',
            '266'=>'7531',    '267'=>'7532',    '268'=>'7533',    '269'=>'7534',    '270'=>'7643',
            '271'=>'7644',    '272'=>'7645',    '273'=>'7646',    '274'=>'7647',    '275'=>'7648',
            '276'=>'7649',    '277'=>'764A',    '278'=>'764B',    '279'=>'764C',    '280'=>'764D',
            '281'=>'764E',    '282'=>'764F',    '283'=>'7650',    '284'=>'7651',    '285'=>'7652',
            '286'=>'7653',    '287'=>'7654',    '288'=>'765D',    '289'=>'765E',    '290'=>'765F',
            '291'=>'7660',    '292'=>'7661',    '293'=>'7662',    '294'=>'7663',    '295'=>'7664',
            '296'=>'7665',    '297'=>'7666',    '298'=>'7774',    '299'=>'7775',    '300'=>'7667',
            '301'=>'7668',    '302'=>'7669',    '303'=>'766A',    '304'=>'766B',    '305'=>'7837',
            '306'=>'7838',    '307'=>'7839',    '308'=>'783A',    '309'=>'783B',    '310'=>'783C',
            '311'=>'783D',    '312'=>'783E',    '313'=>'783F',    '314'=>'7840',    '315'=>'7841',
            '316'=>'7842',    '317'=>'7843',    '318'=>'7844',    '319'=>'7845',    '320'=>'7846',
            '321'=>'7847',    '322'=>'7848',    '323'=>'7849',    '324'=>'784A',    '325'=>'784B',
            '326'=>'784C',    '327'=>'784D',    '328'=>'784E',    '329'=>'784F',    '330'=>'7850',
            '331'=>'7851',    '332'=>'7852',    '333'=>'7853',    '334'=>'7867',    '335'=>'7868',
            '336'=>'7869',    '337'=>'786A',    '338'=>'786B',    '339'=>'786C',    '340'=>'786D',
            '341'=>'786E',    '342'=>'786F',    '343'=>'7870',    '344'=>'7871',    '345'=>'7872',
            '346'=>'7873',    '347'=>'7874',    '348'=>'7875',    '349'=>'7876',    '350'=>'7877',
            '351'=>'7878',    '352'=>'7879',    '353'=>'787A',    '354'=>'787B',    '355'=>'787C',
            '356'=>'787D',    '357'=>'787E',    '358'=>'7921',    '359'=>'7922',    '360'=>'7923',
            '361'=>'7924',    '362'=>'7925',    '363'=>'7926',    '364'=>'7927',    '365'=>'7928',
            '366'=>'7929',    '367'=>'792A',    '368'=>'792B',    '369'=>'792C',    '370'=>'792D',
            '371'=>'792E',    '372'=>'792F',    '373'=>'7930',    '374'=>'7931',    '375'=>'7932',
            '376'=>'7933',    '377'=>'7934',    '378'=>'7935',    '379'=>'7936',    '380'=>'7937',
            '381'=>'7938',    '382'=>'7939',    '383'=>'793A',    '384'=>'793B',    '385'=>'793C',
            '386'=>'793D',    '387'=>'793E',    '388'=>'793F',    '389'=>'7940',    '390'=>'7941',
            '391'=>'7942',    '392'=>'7943',    '393'=>'7944',    '394'=>'7945',    '395'=>'7946',
            '396'=>'7947',    '397'=>'7948',    '398'=>'7949',    '399'=>'794A',    '400'=>'794B',
            '401'=>'794C',    '402'=>'794D',    '403'=>'794E',    '404'=>'794F',    '405'=>'7950',
            '406'=>'7951',    '407'=>'7952',    '408'=>'7953',    '409'=>'7954',    '410'=>'7955',
            '411'=>'7956',    '412'=>'7957',    '413'=>'7958',    '414'=>'7959',    '415'=>'795A',
            '416'=>'795B',    '417'=>'795C',    '418'=>'795D',    '419'=>'795E',    '420'=>'795F',
            '421'=>'7960',    '422'=>'7961',    '423'=>'7962',    '424'=>'7963',    '425'=>'7964',
            '426'=>'7965',    '427'=>'7966',    '428'=>'7967',    '429'=>'7968',    '430'=>'7969',
            '431'=>'796A',    '432'=>'796B',    '433'=>'796C',    '434'=>'796D',    '435'=>'796E',
            '436'=>'796F',    '437'=>'7970',    '438'=>'7971',    '439'=>'7972',    '440'=>'7973',
            '441'=>'7974',    '442'=>'7975',    '443'=>'7976',    '444'=>'7977',    '445'=>'7978',
            '446'=>'7979',    '447'=>'797A',    '448'=>'797B',    '449'=>'797C',    '450'=>'797D',
            '451'=>'797E',    '452'=>'7A21',    '453'=>'7A22',    '454'=>'7A23',    '455'=>'7A2A',
            '456'=>'7A25',    '457'=>'7A26',    '458'=>'7A27',    '459'=>'7A28',    '460'=>'7A29',
            '461'=>'7A2A',    '462'=>'7A2B',    '463'=>'7A2C',    '464'=>'7A2D',    '465'=>'7A2E',
            '466'=>'7A2F',    '467'=>'7A30',    '468'=>'7A31',    '469'=>'7A32',    '470'=>'7A33',
            '471'=>'7A34',    '472'=>'7A35',    '473'=>'7A36',    '474'=>'7A37',    '475'=>'7A38',
            '476'=>'7A39',    '477'=>'7A3A',    '478'=>'7A3B',    '479'=>'7A3C',    '480'=>'7A3D',
            '481'=>'7A3E',    '482'=>'7A3F',    '483'=>'7A40',    '484'=>'7A41',    '485'=>'7A42',
            '486'=>'7A43',    '487'=>'7A44',    '488'=>'7A45',    '489'=>'7A46',    '490'=>'7A47',
            '491'=>'7A48',    '492'=>'7A49',    '493'=>'7A4A',    '494'=>'7A4B',    '495'=>'7A4C',
            '496'=>'7A4D',    '497'=>'7A4E',    '498'=>'7A4F',    '499'=>'7A50',    '500'=>'7854',
            '501'=>'7855',    '502'=>'7856',    '503'=>'7857',    '504'=>'7858',    '505'=>'7859',
            '506'=>'785A',    '507'=>'785B',    '508'=>'785C',    '509'=>'785D',    '510'=>'785E',
            '511'=>'785F',    '512'=>'7860',    '513'=>'7861',    '514'=>'7862',    '515'=>'7863',
            '516'=>'7864',    '517'=>'7865',    '518'=>'7866',    '700'=>'7A51',    '701'=>'7A52',
            '702'=>'7A53',    '703'=>'7A54',    '704'=>'7A55',    '705'=>'7A56',    '706'=>'7A57',
            '707'=>'7A58',    '708'=>'7A59',    '709'=>'7A5A',    '710'=>'7A5B',    '711'=>'7A5C',
            '712'=>'7A5D',    '713'=>'7A5E',    '714'=>'7A5F',    '715'=>'7A60',    '716'=>'7A61',
            '717'=>'7A62',    '718'=>'7A63',    '719'=>'7A64',    '720'=>'7A65',    '721'=>'7A66',
            '722'=>'7A67',    '723'=>'7A68',    '724'=>'7A69',    '725'=>'7A6A',    '726'=>'7A6B',
            '727'=>'7A6C',    '728'=>'7A6D',    '729'=>'7A6E',    '730'=>'7A6F',    '731'=>'7A70',
            '732'=>'7A71',    '733'=>'7A72',    '734'=>'7A73',    '735'=>'7A74',    '736'=>'7A75',
            '737'=>'7A76',    '738'=>'7A77',    '739'=>'7A78',    '740'=>'7A79',    '741'=>'7A7A',
            '742'=>'7A7B',    '743'=>'7A7C',    '744'=>'7A7D',    '745'=>'7A7E',    '746'=>'7B21',
            '747'=>'7B22',    '748'=>'7B23',    '749'=>'7B24',    '750'=>'7B25',    '751'=>'7B26',
            '752'=>'7B27',    '753'=>'7B28',    '754'=>'7B29',    '755'=>'7B2A',    '756'=>'7B2B',
            '757'=>'7B2C',    '758'=>'7B2D',    '759'=>'7B2E',    '760'=>'7B2F',    '761'=>'7B30',
            '762'=>'7B31',    '763'=>'7B32',    '764'=>'7B33',    '765'=>'7B34',    '766'=>'7B35',
            '767'=>'7B36',    '768'=>'7B37',    '769'=>'7B38',    '770'=>'7B39',    '771'=>'7B3A',
            '772'=>'7B3B',    '773'=>'7B3C',    '774'=>'7B3D',    '775'=>'7B3E',    '776'=>'7B3F',
            '777'=>'7B40',    '778'=>'7B41',    '779'=>'7B42',    '780'=>'7B43',    '781'=>'7B44',
            '782'=>'7B45',    '783'=>'7B46',    '784'=>'7B47',    '785'=>'7B48',    '786'=>'7B49',
            '787'=>'7B4A',    '788'=>'7B4B',    '789'=>'7B4C',    '790'=>'7B4D',    '791'=>'7B4E',
            '792'=>'7B4F',    '793'=>'7B50',    '794'=>'7B51',    '795'=>'7B52',    '796'=>'7B53',
            '797'=>'7B54',    '798'=>'7B55',    '799'=>'7B56',    '800'=>'7B57',    '801'=>'7B58',
            '802'=>'7B59',    '803'=>'7B5A',    '804'=>'7B5B',    '805'=>'7B5C',    '806'=>'7B5D',
            '807'=>'7B5E',    '808'=>'7B5F',    '809'=>'7B60',    '810'=>'7B61',    '811'=>'7B62',
            '812'=>'7B63',    '813'=>'7B64',    '814'=>'7B65',    '815'=>'7B66',    '816'=>'7B67',
            '817'=>'7B68',    '818'=>'7B69',    '819'=>'7B6A',    '820'=>'7B6B',    '821'=>'7B6C',
            '822'=>'7B6D',    '823'=>'7B6E',    '824'=>'7B6F',    '825'=>'7B70',    '826'=>'7B71',
            '827'=>'7B72',    '828'=>'7B73',    
        );
        return empty($map[$dec])?'':pack('H4',$map[$dec]);
    }

    /**
     * 独自タグからUTF-8 SoftBankへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2sbpack($dec)
    {
        $map = array(
              '1'=>'EE8992',            '2'=>'EE80A1',                '3'=>'EE80A0',                '4'=>'5b515d',                  '5'=>'EE88BB',
              '6'=>'EE88BA',            '7'=>'EE88BD',                '8'=>'EE88BC',                '9'=>'EE889B',               '10'=>'EE889A',
             '11'=>'5b695d',             '12'=>'EE8184',               '13'=>'EE8581',               '14'=>'EE84AF',               '15'=>'EE818C',
             '16'=>'EE84BD',           '17'=>'EE889B',               '18'=>'EE889A',               '19'=>'EE889B',               '20'=>'EE889B',
             '21'=>'EE889B',           '22'=>'EE889A',               '23'=>'EE8899',               '24'=>'EE8899',               '25'=>'5be88595e69982e8a8885d',
             '26'=>'efbc8b',              '27'=>'efbc8d',                  '28'=>'efbc8a',                  '29'=>'EE88B2',               '30'=>'EE88B3',
             '31'=>'5be7a681e6ada25d',          '32'=>'e296bc',                  '33'=>'e296b2',                  '34'=>'e296bc',                  '35'=>'e296b2',
             '36'=>'EE889B',           '37'=>'EE889B',               '38'=>'EE889B',               '39'=>'EE889A',               '40'=>'EE8899',
             '41'=>'EE8899',           '42'=>'EE88B7',               '43'=>'EE88B8',               '44'=>'EE818A',               '45'=>'EE8096',
             '46'=>'EE80AD',           '47'=>'EE818C',               '48'=>'EE8CA5',               '49'=>'cf86',                  '50'=>'EE8082',
             '51'=>'EE80A2',           '52'=>'EE8184',               '53'=>'EE8490',               '54'=>'EE94B7',               '55'=>'EE8CB3',
             '56'=>'EE8C81',           '57'=>'5be7a082e69982e8a8885d',            '58'=>'5be7a082e69982e8a8885d',            '59'=>'EE8C96',               '60'=>'5be99baae7b590e699b65d',
             '61'=>'EE8CB3',           '62'=>'EE8CB3',               '63'=>'EE88B4',               '64'=>'EE88B5',               '65'=>'EE8187',
             '66'=>'c3b7',              '67'=>'5be382abe383ace383b3e38380e383bc5d',        '68'=>'EE8196',               '69'=>'EE8CAF',               '70'=>'EE88B6',
             '71'=>'EE88B9',           '72'=>'EE80B4',               '73'=>'5be38381e382a7e38383e382afe3839ee383bce382af5d',    '74'=>'EE8192',               '75'=>'e29886e5bda1',
             '76'=>'EE8CAE',           '77'=>'EE848F',               '78'=>'EE94A3',               '79'=>'5be38395e382a9e383abe383805d',          '80'=>'EE8081',
             '81'=>'EE898E',           '82'=>'EE898F',               '83'=>'EE8CA3',               '84'=>'5be38395e382a9e383abe383805d',          '85'=>'EE8089',
             '86'=>'5be38395e382ade38380e382b75d',      '87'=>'5be382abe383bce383895d',            '88'=>'e296b2',                  '89'=>'e296bc',                  '90'=>'EE948C',
             '91'=>'EE8588',           '92'=>'EE8C81',               '93'=>'EE8185',               '94'=>'EE8088',               '95'=>'EE818B',
             '96'=>'EE90AB',           '97'=>'EE8588',               '98'=>'EE84B7',               '99'=>'EE858E',              '100'=>'EE8588',
            '101'=>'EE8588',          '102'=>'EE8588',              '103'=>'EE8C81',              '104'=>'EE8C93',              '105'=>'5be382abe383ace383b3e38380e383bc5d',
            '106'=>'EE84A5',          '107'=>'EE8189',              '108'=>'EE8483',              '109'=>'efbfa5',                 '110'=>'EE80BD',
            '111'=>'EE80BD',          '112'=>'EE80B6',              '113'=>'EE8C84',              '114'=>'5be58c85e4b8815d',             '115'=>'EE84A9',
            '116'=>'5be383a1e382ace3838d5d',       '117'=>'e29494e28692',               '118'=>'e28690e29498',               '119'=>'EE8494',              '120'=>'EE80BF',
            '121'=>'EE8588',          '122'=>'EE8588',              '123'=>'5be3838de382b85d',             '124'=>'EE84BE',              '125'=>'EE809B',
            '126'=>'EE8C96',          '127'=>'EE858A',              '128'=>'EE858A',              '129'=>'EE8481',              '130'=>'5be68790e4b8ade99bbbe781af5d',
            '131'=>'EE8588',          '132'=>'5be38381e382a7e38383e382afe3839ee383bce382af5d',   '133'=>'EE8498',              '134'=>'EE8192',              '135'=>'5be99bbbe6b1a05d',
            '136'=>'5be382b9e382afe383ade383bce383ab5d',   '137'=>'5be794bbe381b3e38287e381865d',         '138'=>'EE8584',              '139'=>'EE84AF',              '140'=>'EE88B0',
            '141'=>'EE88B1',          '142'=>'EE8588',              '143'=>'5be382afe383aae38383e383975d',         '144'=>'EE8492',              '145'=>'5be5908de69cad5d',
            '146'=>'EE8183',          '147'=>'EE8588',              '148'=>'EE90AF',              '149'=>'EE8C81',              '150'=>'5b5044435d',
            '151'=>'EE8483',          '152'=>'5be383ace383b3e383815d',           '153'=>'5be98081e4bfa1424f585d',          '154'=>'5be58f97e4bfa1424f585d',          '155'=>'EE8089',
            '156'=>'EE80B8',          '157'=>'5be5ae9ae8a68f5d',             '158'=>'5be4b889e8a792e5ae9ae8a68f5d',         '159'=>'5be382b0e383a9e383955d',           '160'=>'5be882895d',
            '161'=>'EE808A',          '162'=>'5be382b3e383b3e382bbe383b3e383885d',       '163'=>'5be5aeb6e6978f5d',             '164'=>'5be383aae383b3e382af5d',           '165'=>'EE8492',
            '166'=>'EE808B',          '167'=>'EE818A',              '168'=>'EE809D',              '169'=>'EE809C',              '170'=>'5be382b5e382a4e382b3e383ad5d',
            '171'=>'5be696b0e8819e5d',         '172'=>'EE809E',              '173'=>'e38080',                 '174'=>'',                   '175'=>'',
            '176'=>'EE8C8E',          '177'=>'EE8888',              '178'=>'EE888A',              '179'=>'EE8889',              '180'=>'EE889C',
            '181'=>'EE889D',          '182'=>'EE889E',              '183'=>'EE889F',              '184'=>'EE88A0',              '185'=>'EE88A1',
            '186'=>'EE88A2',          '187'=>'EE88A3',              '188'=>'EE88A4',              '189'=>'[10]',               '190'=>'EE9183',
            '191'=>'EE8188',          '192'=>'EE88BF',              '193'=>'EE8980',              '194'=>'EE8981',              '195'=>'EE8982',
            '196'=>'EE8983',          '197'=>'EE8984',              '198'=>'EE8985',              '199'=>'EE8986',              '200'=>'EE8987',
            '201'=>'EE8988',          '202'=>'EE8989',              '203'=>'EE898A',              '204'=>'EE898B',              '205'=>'EE8594',
            '206'=>'EE8596',          '207'=>'EE8591',              '208'=>'EE858F',              '209'=>'EE8590',              '210'=>'EE858B',
            '211'=>'EE8882',          '212'=>'EE858D',              '213'=>'EE80BA',              '214'=>'5be59cb0e59bb35d',             '215'=>'EE84B6',
            '216'=>'EE8599',          '217'=>'EE809F',              '218'=>'EE8495',              '219'=>'EE8098',              '220'=>'EE8095',
            '221'=>'5be382b9e3838ee3839c5d',       '222'=>'EE84B2',              '223'=>'EE84A4',              '224'=>'EE84A3',              '225'=>'EE8C8B',
            '226'=>'EE8CA4',          '227'=>'EE918B',              '228'=>'EE9489',              '229'=>'EE84B3',              '230'=>'5be382aae383a1e38387e38388e382a65d',
            '231'=>'EE84B0',          '232'=>'5be382b2e383bce383a05d',           '233'=>'EE84AF',              '234'=>'EE80B3',              '235'=>'EE80B0',
            '236'=>'EE849B',          '237'=>'EE948B',              '238'=>'EE8D88',              '239'=>'EE8186',              '240'=>'EE8587',
            '241'=>'5be38195e3818fe38289e38293e381bc5d',   '242'=>'EE8099',              '243'=>'EE8D87',              '244'=>'EE8D82',              '245'=>'EE84A0',
            '246'=>'EE8194',          '247'=>'EE94AC',              '248'=>'EE809A',              '249'=>'EE8489',              '250'=>'EE94B1',
            '251'=>'EE818F',          '252'=>'EE8195',              '253'=>'5be382a2e383aa5d',             '254'=>'EE848B',              '255'=>'EE8C87',
            '256'=>'EE8C85',          '257'=>'EE8197',              '258'=>'EE8199',              '259'=>'EE9091',              '260'=>'EE9086',
            '261'=>'EE84BC',          '262'=>'EE8CB4',              '263'=>'EE8CB1',              '264'=>'EE8485',              '265'=>'EE80A3',
            '266'=>'EE8CA7',          '267'=>'EE8CAE',              '268'=>'EE8C91',              '269'=>'EE849D',              '270'=>'5b534f535d',
            '271'=>'EE858C',          '272'=>'EE8CA9',              '273'=>'EE8083',              '274'=>'EE848C',              '275'=>'5be381aae3828be381a85d',
            '276'=>'EE94B6',          '277'=>'EE849A',              '278'=>'5be88ab1e4b8b85d',             '279'=>'EE8C95',              '280'=>'[100点]',
            '281'=>'EE808D',          '282'=>'EE8CB0',              '283'=>'EE819A',              '284'=>'EE808F',              '285'=>'EE88A6',
            '286'=>'EE849C',          '287'=>'EE808E',              '288'=>'EE84AA',              '289'=>'EE80BC',              '290'=>'5be8b2a1e5b8835d',
            '291'=>'EE8CA6',          '292'=>'EE8181',              '293'=>'5be38390e382a4e382aae383aae383b35d',       '294'=>'EE8C8A',              '295'=>'EE8C9C',
            '296'=>'EE8493',          '297'=>'EE8C9E',              '298'=>'5b455a5d',               '299'=>'[FREE]',             '300'=>'EE84A6',
            '301'=>'EE8086',          '302'=>'EE848C',              '303'=>'EE8893',              '304'=>'EE84BB',              '305'=>'5be99ca75d',
            '306'=>'EE8094',          '307'=>'EE90AA',              '308'=>'5be3839de382b1e38399e383ab5d',         '309'=>'EE9482',              '310'=>'EE9483',
            '311'=>'5be382a4e38399e383b3e383885d',     '312'=>'EE8C94',              '313'=>'EE8D8B',              '314'=>'EE888E',              '315'=>'EE888D',
            '316'=>'EE888F',          '317'=>'EE9099',              '318'=>'EE909B',              '319'=>'EE8091',              '320'=>'EE8092',
            '321'=>'e2978f',             '322'=>'EE818C',              '323'=>'EE818C',              '324'=>'5b434c5d',               '325'=>'EE88A5',
            '326'=>'EE898D',          '327'=>'EE9086',              '328'=>'EE8CA7',              '329'=>'5be38389e383b3e383835d',           '330'=>'EE8CB1',
            '331'=>'5b657a706c75735d',       '332'=>'5be59cb0e790835d',             '333'=>'EE8D80',              '334'=>'EE8892',              '335'=>'EE8086',
            '336'=>'EE8087',    '337'=>'EE808C',              '338'=>'EE84A8',              '339'=>'EE80B2',              '340'=>'EE80B7',
            '341'=>'EE90B4',          '342'=>'EE80BB',              '343'=>'EE80BE',              '344'=>'EE818E',              '345'=>'EE8190',
            '346'=>'EE8191',          '347'=>'EE8193',              '348'=>'EE9085',              '349'=>'EE8486',              '350'=>'EE9090',
            '351'=>'EE8488',          '352'=>'EE848A',              '353'=>'EE848D',              '354'=>'EE848E',              '355'=>'EE8491',
            '356'=>'EE8496',          '357'=>'EE8497',              '358'=>'EE8499',              '359'=>'EE849E',              '360'=>'EE84A1',
            '361'=>'EE84A2',          '362'=>'EE84AD',              '363'=>'EE84AE',              '364'=>'EE84B1',              '365'=>'5be382abe383a15d',
            '366'=>'EE9491',          '367'=>'EE9492',              '368'=>'EE84B7',              '369'=>'EE84BF',              '370'=>'EE8583',
            '371'=>'EE8586',          '372'=>'EE94A3',              '373'=>'EE858A',              '374'=>'EE8592',              '375'=>'EE8593',
            '376'=>'EE8595',          '377'=>'EE8597',              '378'=>'EE8598',              '379'=>'EE8882',              '380'=>'EE8887',
            '381'=>'EE888B',          '382'=>'EE8894',              '383'=>'EE88A7',              '384'=>'EE88A8',              '385'=>'EE88A9',
            '386'=>'EE88AA',          '387'=>'EE88AB',              '388'=>'EE88AC',              '389'=>'EE88AD',              '390'=>'EE88AE',
            '391'=>'EE88AF',          '392'=>'EE88BE',              '393'=>'EE8990',              '394'=>'EE8991',              '395'=>'EE8C81',
            '396'=>'EE8C82',          '397'=>'EE8C83',              '398'=>'EE8C86',              '399'=>'EE8C88',              '400'=>'EE8C8B',
            '401'=>'EE8C8C',          '402'=>'EE8C8D',              '403'=>'EE8C8F',              '404'=>'EE8C90',              '405'=>'EE8C92',
            '406'=>'5b455ae3838ae383935d',       '407'=>'EE8C98',              '408'=>'EE8C9B',              '409'=>'EE8C9D',              '410'=>'EE8C9F',
            '411'=>'EE8CA0',          '412'=>'EE8CA1',              '413'=>'EE8CA2',              '414'=>'EE888C',              '415'=>'EE8CA7',
            '416'=>'EE8CAA',          '417'=>'EE8CAB',              '418'=>'EE8CAC',              '419'=>'EE8CAD',              '420'=>'EE8CAE',
            '421'=>'EE8093',          '422'=>'EE8CB2',              '423'=>'EE8CB8',              '424'=>'EE8CB9',              '425'=>'EE8CBA',
            '426'=>'EE8CBB',          '427'=>'EE8CBC',              '428'=>'EE8CBD',              '429'=>'EE8CBE',              '430'=>'EE8CBF',
            '431'=>'EE8D81',          '432'=>'EE8D83',              '433'=>'EE8D84',              '434'=>'EE8D85',              '435'=>'EE8D86',
            '436'=>'EE8D89',          '437'=>'EE8D8A',              '438'=>'EE8D8C',              '439'=>'EE8D8D',              '440'=>'EE9082',
            '441'=>'EE9083',          '442'=>'EE9084',              '443'=>'EE9086',              '444'=>'EE9087',        '445'=>'EE9088',
            '446'=>'EE908A',          '447'=>'EE908B',              '448'=>'EE908C',              '449'=>'EE908D',              '450'=>'EE908E',
            '451'=>'EE9090',          '452'=>'EE908F',              '453'=>'EE8CA6',              '454'=>'EE8196',              '455'=>'EE9097',
            '456'=>'EE9098',          '457'=>'EE909A',              '458'=>'EE909C',              '459'=>'EE909D',              '460'=>'EE909F',
            '461'=>'EE90A0',          '462'=>'EE90A1',              '463'=>'EE909E',              '464'=>'EE90A3',              '465'=>'EE90A4',
            '466'=>'EE90A6',          '467'=>'EE90A5',              '468'=>'EE90A9',              '469'=>'EE8182',              '470'=>'EE90AC',
            '471'=>'EE90AD',          '472'=>'EE90B0',              '473'=>'EE90B1',              '474'=>'EE90B2',              '475'=>'EE90B3',
            '476'=>'EE90B6',          '477'=>'EE90B8',              '478'=>'EE90B9',              '479'=>'EE90BA',              '480'=>'EE90BB',
            '481'=>'EE90BC',          '482'=>'5be88ab1e5ab815d',             '483'=>'EE90BF',              '484'=>'EE9180',              '485'=>'EE9181',
            '486'=>'EE9182',          '487'=>'EE9185',              '488'=>'EE9186',              '489'=>'EE9188',              '490'=>'EE918B',
            '491'=>'EE918C',          '492'=>'EE9481',              '493'=>'EE9189',              '494'=>'EE9483',              '495'=>'EE9484',
            '496'=>'EE9485',          '497'=>'EE9486',              '498'=>'EE9488',              '499'=>'EE948D',              '500'=>'5be382aae383bce38397e383b3e382a6e382a7e383965d',
            '501'=>'EE8584',          '502'=>'5b414243445d',             '503'=>'5b616263645d',             '504'=>'[1234]',             '505'=>'5be8a898e58fb75d',
            '506'=>'5be58faf5d',           '507'=>'5be38381e382a7e38383e382afe3839ee383bce382af5d',   '508'=>'5be3839ae383b35d',             '509'=>'5be383a9e382b8e382aae3839ce382bfe383b35d',     '510'=>'EE8494',
            '511'=>'EE88B5',          '512'=>'5be38396e38383e382afe3839ee383bce382af5d',     '513'=>'EE8484',              '514'=>'EE80B6',              '515'=>'EE8481',
            '516'=>'EE8C81',          '517'=>'EE8584',              '518'=>'e28691e28693',               '700'=>'EE948E',              '701'=>'EE948F',
            '702'=>'EE9490',          '703'=>'EE9493',              '704'=>'EE9494',              '705'=>'EE9495',              '706'=>'EE9496',
            '707'=>'EE9497',          '708'=>'EE9498',              '709'=>'EE9499',              '710'=>'EE949A',              '711'=>'EE949B',
            '712'=>'EE949C',          '713'=>'EE94A0',              '714'=>'EE949F',              '715'=>'EE94A2',              '716'=>'EE94A5',
            '717'=>'EE94A6',          '718'=>'EE94A7',              '719'=>'EE94AB',              '720'=>'EE94AD',              '721'=>'EE94AE',
            '722'=>'EE94AF',          '723'=>'EE94B0',              '724'=>'EE94B2',              '725'=>'EE94B3',              '726'=>'EE94B5',
            '727'=>'EE94B4',          '728'=>'EE94B6',              '729'=>'EE8087',        '730'=>'5be697975d',               '731'=>'EE88B6',
            '732'=>'EE88B8',          '733'=>'efbc81efbc9f',               '734'=>'efbc81efbc81',               '735'=>'efbd9e',                 '736'=>'5be383a1e383ade383b35d',
            '737'=>'5be38391e382a4e3838ae38383e38397e383ab5d', '738'=>'5be38396e38389e382a65d',           '739'=>'5be38390e3838ae3838a5d',           '740'=>'5be381a8e38186e38282e3828de38193e381975d',     '741'=>'5be382ade3838ee382b35d',
            '742'=>'5be6a0975d',           '743'=>'5be383a2e383a25d',             '744'=>'5be38284e3818de38184e382825d',         '745'=>'5be38394e382b65d',             '746'=>'5be38381e382ade383b35d',
            '747'=>'5be4b883e5a4955d',         '748'=>'EE8184',              '749'=>'5be8beb05d',               '750'=>'5be38394e382a2e3838e5d',           '751'=>'EE8097',
            '752'=>'EE8099',          '753'=>'5be3839ce383bce383aae383b3e382b05d',       '754'=>'5be381aae381bee381afe381925d',         '755'=>'5be5a4a9e78b975d',             '756'=>'5be38391e383b3e383805d',
            '757'=>'EE9089',          '758'=>'EE848B',              '759'=>'EE8C85',              '760'=>'5be382a2e382a4e382b9e382afe383aae383bce383a05d',   '761'=>'5be38389e383bce3838ae383845d',
            '762'=>'5be382afe38383e382ade383bc5d',     '763'=>'5be38381e383a7e382b35d',           '764'=>'5be382ade383a3e383b3e38387e382a35d',       '765'=>'5be382ade383a3e383b3e38387e382a35d',       '766'=>'282f5fefbcbc29',
            '767'=>'28e383bbc397e383bb29',       '768'=>'7c28e383bbc397e383bb297c',         '769'=>'5be781abe5b1b15d',             '770'=>'EE8CA8',              '771'=>'5b4142435d',
            '772'=>'5be38397e383aae383b35d',       '773'=>'5be3839fe38384e38390e383815d',         '774'=>'5be381a6e38293e381a8e38186e899ab5d',       '775'=>'5be3838fe38381e3839fe383845d',         '776'=>'EE8D85',
            '777'=>'5be9a39be38293e381a7e38184e3818fe987915d', '778'=>'EE9087',        '779'=>'EE9096',              '780'=>'EE9096',              '781'=>'EE918B',
            '782'=>'EE9098',          '783'=>'EE8197',              '784'=>'EE8483',              '785'=>'EE9092',              '786'=>'EE9092',
            '787'=>'EE8486',          '788'=>'EE9083',              '789'=>'EE9083',              '790'=>'EE9093',              '791'=>'EE9093',
            '792'=>'EE9084',          '793'=>'EE8C99',              '794'=>'5be383a2e382a2e382a45d',           '795'=>'EE80B9',              '796'=>'5be88ab1e69cad5d',
            '797'=>'5be382b8e383a7e383bce382abe383bc5d',   '798'=>'5be382a8e38393e38395e383a9e382a45d',       '799'=>'EE8483',              '800'=>'EE8881',              '801'=>'EE90B2',
            '802'=>'5b455ae383a0e383bce38393e383bc5d',   '803'=>'EE8CA7',              '804'=>'EE94A3',              '805'=>'5be382b8e383bce383b3e382ba5d',         '806'=>'EE8483',
            '807'=>'e28691e28693',           '808'=>'e28794',                 '809'=>'e28691e28693',               '810'=>'EE90BE',              '811'=>'EE8490',
            '812'=>'5be382abe382bfe38384e383a0e383aa5d',   '813'=>'EE9084',              '814'=>'EE9084',              '815'=>'5b43e383a1e383bce383ab5d',          '816'=>'EE8490',
            '817'=>'EE8090',          '818'=>'EE8890',              '819'=>'EE8092',              '820'=>'EE90A7',              '821'=>'EE9083',
            '822'=>'EE9096',
        );
        return empty($map[$dec])?'':pack('H*', $map[$dec]);
    }
} // emoji_Tag
?>