<?php
/* SVN FILE: $Id: HTMLSax3.php 549 2008-06-07 04:13:20Z bb_yujiro $ */
/**
 * HTMLSax3による属性の除去
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 549 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-07 13:13:20 +0900 (土, 07 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'PEAR/XML/HTMLSax3.php';

/**
 * HTMLSax3による属性の除去クラス
 *
 * @category        Request
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 549 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-07 13:13:20 +0900 (土, 07 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Request_StripAttributes_HTMLSax3
{
    /**
     * 許可するタグの要素
     * @var array
     */
    private $_allowables = array();

    /**
     * Scriptタグの消去
     * @var array
     */
    private $_stripscript = false;

    /**
     * 解析結果
     * @var string
     */
    private $_parsed = '';

    /**
     * XML_HTMLSax3
     * @var object
     */
    private $_parser = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $filename テンプレートファイル名
     * @return void
     */
    public function __construct()
    {
        $this->_parser = new XML_HTMLSax3();

        // Register the handler with the parser
        $this->_parser->set_object($this);

        // Set a parser option
        // $this->_parser->set_option('XML_OPTION_TRIM_DATA_NODES');

        // Set the handlers
        $this->_parser->set_element_handler('openHandler', 'closeHandler');
        $this->_parser->set_data_handler('dataHandler');
        $this->_parser->set_escape_handler('escapeHandler');
        $this->_parser->set_jasp_handler('jaspHandler');
    }

    /**
     * 許可するタグの要素を設定
     *
     * @access public
     * @param string $allowable
     * @return void
     */
    public function setAllowable ($allowable) 
    {
        $this->_allowables = explode(',', $allowable);
    }

    /**
     * Scriptタグの消去設定
     *
     * @access public
     * @param string $stripscript
     * @return void
     */
    public function setStripScript ($stripscript) 
    {
        $this->_stripscript = $stripscript;
    }

    /**
     * 解析結果の取得
     *
     * @access public
     * @return string
     */
    public function getParsed ($source) 
    {
        $this->_parser->parse($source);

        return $this->_parsed;
    }

    /**
     * 解析結果の初期化
     *
     * @access public
     */
    public function refreshParsed()
    {
        $this->_parsed = null;
    }

    /**
     * openHandler
     *
     * @access public
     * @param object(XML_HTMLSax3) $parser
     * @param string $element
     * @param array $attrs
     * @return void
     */
    public function openHandler(&$parser, $element, $attrs)
    {
        $element = strtolower($element);
        if ($element != 'script' || !$this->_stripscript){
            $this->_parsed .= '<'.$element;

            $this->writeAttrs($attrs);

            $this->_parsed .= '>';
        }
    }

    /**
     * openHandler
     *
     * @access public
     * @param object(XML_HTMLSax3) $parser
     * @param string $element
     * @return void
     */
    public function closeHandler(&$parser, $element)
    {
        $element = strtolower($element);
        if ($element != 'script' || !$this->_stripscript){
            $this->_parsed .= '</'.$element.'>';
        }
    }

    /**
     * dataHandler(TextNode)
     *
     * @access public
     * @param object(XML_HTMLSax3) $parser
     * @param string $data
     * @return void
     */
    public function dataHandler(&$parser, $data)
    {
        $this->_parsed .= $data;
    }

    /**
     * escapeHandler(コメント)
     *
     * @access public
     * @param object(XML_HTMLSax3) $parser
     * @param string $text
     * @return void
     */
    public function escapeHandler(&$parser, $data)
    {
        if (!$this->_stripscript){
            $this->_parsed .= '<!-- '.$data.' -->';
        }
    }

    /**
     * jaspHandler(JavaScript)
     *
     * @access public
     * @param object(XML_HTMLSax3) $parser
     * @param string $text
     * @return void
     */
    public function jaspHandler(&$parser, $data)
    {
        if ($this->_stripscript){
            return ;
        }
        $this->_parsed .= $data;
    }

    /**
     * 属性の処理
     *
     * @access public
     * @param array $attrs
     * @return void
     */
    public function writeAttrs ($attrs)
    {
        if (is_array($attrs)) {
            foreach ($attrs as $name => $value) {
                $name = strtolower($name);
                if (in_array($name, $this->_allowables)) {
                    $this->_parsed .= ' '.$name.'="'.$value.'"';
                }
            }
        }
    }
} // Request_StripAttributes_HTMLSax3
?>
