<?php
/* SVN FILE: $Id: StripAttributes.php 331 2008-05-11 01:12:41Z bb_yujiro $ */
/**
 * 属性の除去
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 331 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:12:41 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 属性の除去クラス
 *
 * @category        Request
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 331 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:12:41 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Request_StripAttributes
{
    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @param string $driver
     * @return object __CLASS__
     */
    public static function getInstance($driver)
    {
        if (!isset(self::$_instance)) {
            self::$_instance = self::factory($driver);
        }

        return self::$_instance;
    }

    /**
     * Factory メソッド
     *
     * @access public
     * @param string $driver
     * @return void
     */
    public static function factory($driver)
    {
        if (include LIB_DIR.'rktRequest/StripAttributes/'.$driver.'.php') {
            $classname = 'Request_StripAttributes_'.$driver;
            return new $classname;
        } else {
            throw new Exception ('Driver not found');
        }
    }
} // stripTags
?>
