<?php
/* SVN FILE: $Id: GD.php 182 2008-04-26 17:18:59Z bb_yujiro $ */
/**
 *  GDによる画像処理
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 182 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-27 02:18:59 +0900 (日, 27 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 *  GD操作クラス
 *
 * @category        Image
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 182 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-27 02:18:59 +0900 (日, 27 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Image_GD
{
    /**
     * 画像ファイル名
     * @var string
     */
    private $_filename;

    /**
     * 画像タイプ
     * @var string
     */
    private $_type = null;

    /**
     * フォーマット
     * @var string
     */
    private $_format = null;

    /**
     * 画像名
     * @var string
     */
    private $_name = null;

    /**
     * 幅
     * @var integer
     */
    private $_width = null;

    /**
     * 高さ
     * @var integer
     */
    private $_height = null;

    /**
     * 画像リソース
     * @var resource
     */
    private $_image = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $source
     * @return void
     */
    public function __construct($filename=null)
    {
        if (empty($filename)){
            return ;
        }

        $this->_filename = $filename;
        $this->readImage($this->_filename);
    }

    /**
     * 画像情報をバッファに格納
     *
     * @access private
     * @return boolean
     */
    public function readImage($filename)
    {
        $this->_filename = $filename;
        if (!file_exists ($this->_filename)){
            return false;
        }
        $this->_setInfo();

        $func = array(
            'jpg'=>  'imageCreateFromJpeg',
            'jpeg'=> 'imageCreateFromJpeg',
            'gif'=>  'imageCreateFromGif',
            'png'=>  'imageCreateFromPNG',
            'wbmp'=> 'imageCreateFromWbmp',
        );

        $this->_image = call_user_func($func[$this->_format], $filename);
        
        return true;
    }

    /**
     * ファイル情報の取得
     *
     * @access private
     * @return object
     */
    public function _setInfo()
    {
        $extensions = array(
            '1'=>'gif',
            '2'=>'jpg',
            '3'=>'png',
            '4'=>'swf',
            '5'=>'psd',
            '6'=>'bmp',
            '7'=>'tiff',
            '8'=>'tiff'
        );

        $size = getImageSize($this->_filename);

        $this->_type   = $extensions[$size[2]];
        $this->_format = $extensions[$size[2]];
        $this->_name   = basename($this->_filename);
        $this->_width  = $size[0];
        $this->_height = $size[1];
    }

    /*_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
          basic
      _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/*/

    /**
     * 対象画像のバイナリを取得
     *
     * @access public
     * @param string $filename 画像のファイル名
     * @return void
     */
    public function output()
    {
        $type = $this->_format;
        $type = preg_replace('/jpg/i','jpeg',$type);
        Header('Content-Type: image/'.$type);
        Header('Content-disposition: inline; filename='.$this->_name);

        $func = array(
            'jpg'=>  'imageJpeg',
            'jpeg'=> 'imageJpeg',
            'gif'=>  'imageGif',
            'png'=>  'imagePNG',
            'wbmp'=> 'imageWbmp',
        );
        @call_user_func($func[$this->_format], $this->_image);
        exit();
    }

    /**
     * 対象画像のリサイズ値を取得
     *
     * @access public
     * @param string $filename 画像のファイル名
     * @return boolean
     */
    public function save($filename)
    {
        $func = array(
            'jpg'=>  'imageJpeg',
            'jpeg'=> 'imageJpeg',
            'gif'=>  'imageGif',
            'png'=>  'imagePNG',
            'wbmp'=> 'imageWbmp',
        );

        return @call_user_func($func[$this->_format], $this->_image, $filename);
    }

    /**
     * 画像情報の取得
     *
     * @access public
     * @return array 画像情報
     */
    public function getInfo()
    {
        if (is_resource($this->_image)){
            $this->_width  = imagesx($this->_image);
            $this->_height = imagesy($this->_image);
        }

        return array(
            'type'=>   $this->_type,
            'format'=> $this->_format,
            'name'=>   $this->_name,
            'width'=>  $this->_width,
            'height'=> $this->_height,
        );
    }

    /**
     * 画像バイナリデータの取得
     *
     * @access public
     * @return binary
     */
    public function getBinary()
    {
        $func = array(
            'jpg'=>  'imageJpeg',
            'jpeg'=> 'imageJpeg',
            'gif'=>  'imageGif',
            'png'=>  'imagePNG',
            'wbmp'=> 'imageWbmp',
        );

        ob_start();
        @call_user_func($func[$this->_format], $this->_image);
        $binary = ob_get_contents();
        ob_end_clean();

        return $binary;
    }

    /**
     * 対象画像フォーマットの変換
     *
     * @access public
     * @param string $format 変換する画像フォーマット
     * @return boolean
     */
    public function convert($format)
    {
        $this->_type = $format;
        $this->_format = $format;
        
        return true;
    }

    /**
     * 対象画像フォーマットの変換
     *
     * @access public
     * @param integer $width 画像の幅
     * @param integer $height 画像の高さ
     * @param string $color 背景色
     * @param string $format フォーマット
     * @return boolean
     */
    public function create($width, $height, $color='white', $format='jpg')
    {
        $this->_image = imageCreateTrueColor($width, $height);

        $this->_type   = $format;
        $this->_format = strtolower($format);
        $this->_name   = 'none.'.$this->_format;
        $this->_width  = $width;
        $this->_height = $height;
        
        return is_resource($this->_image);
    }

    /**
     * 画像バイナリデータの設定
     *
     * @access public
     * @param binary $binary 画像バイナリデータ
     * @param string $format フォーマット
     * @return boolean
     */
    public function setBinary($binary, $format)
    {
        $this->_image = imageCreateFromString($binary);

        $this->_type   = $format;
        $this->_format = strtolower($format);
        $this->_name   = 'none.'.$this->_format;
        $this->_width  = imagesx($this->_image);
        $this->_height = imagesy($this->_image);

        return true;
    }

    /*_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
          move px
      _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/*/

    /**
     * 対象画像を切り取る
     *
     * @access public
     * @param integer $width 画像の幅
     * @param integer $height 画像の高さ
     * @param integer $x x軸の移動ピクセル
     * @param integer $y y軸の移動ピクセル
     * @return boolean
     */
    public function crop($width, $height, $x=0, $y=0)
    {
        $crop = imageCreateTrueColor($width, $height);

        imageCopy($crop, $this->_image, 0, 0, $x, $y, $width, $height);

        imageDestroy($this->_image);
        $this->_image = $crop;

        $this->_width  = $width;
        $this->_height = $height;
    }

    /**
     * 対象画像のリサイズ
     *
     * @access public
     * @param integer $width 画像の幅
     * @param integer $height 画像の高さ
     * @param boolean $exactly 指定サイズを厳守
     * @return boolean
     */
    public function resize($width, $height, $exactly=false)
    {
        if (!$exactly){
            $w_scale = $width  / $this->_width;
            $h_scale = $height / $this->_height;

            /* 倍率の決定 */
            $scale = ($w_scale < $h_scale)?$w_scale:$h_scale;
    
            /* 縮小のみは以下を実行 */
            $scale = ($scale >= 1.0)?1:$scale;        
            $width  = intval($this->_width * $scale);
            $height = intval($this->_height * $scale);
        } // if (!$exactly)

        /* 背景色が白のキャンバスを作成 */
        $resize = imageCreateTrueColor($width, $height);
        $bg_color  = imageColorAllocate($resize, 255, 255, 255);
        imageFill($resize, 0, 0, $bg_color);

        imageCopyResampled($resize, $this->_image,
                        0, 0, 0, 0, $width, $height,
                        $this->_width, $this->_height);

        imageDestroy($this->_image);
        $this->_image = $resize;

        $this->_width  = $width;
        $this->_height = $height;

        return true;
    }

    /**
     * 対象画像の回転
     *
     * @access public
     * @param integer $angle 回転角度
     * @return boolean
     */
    public function rotate($angle)
    {
        $white = imageColorAllocate($this->_image, 0xFF, 0xFF, 0xFF);

        $rotate = imageRotate($this->_image, $angle, $white);
        imageDestroy($this->_image);
        $this->_image = $rotate;

        $this->_width  = imagesx($this->_image);
        $this->_height = imagesy($this->_image);

        return true;
    }
} // Image_GD
?>