<?php
/* SVN FILE: $Id: Common.php 246 2008-05-03 20:32:15Z bb_yujiro $ */
/**
 * BLOB共通
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 246 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-04 05:32:15 +0900 (日, 04 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * BLOB_Commonクラス
 *
 * @category        Binary Large OBject
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 246 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-04 05:32:15 +0900 (日, 04 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class BLOB_Common
{
    /**
     * ファイル名キー
     * @var string
     */
    protected $origin = '';

    /**
     * ファイル名
     * @var string
     */
    protected $name = '';

    /**
     * MIMEタイプ
     * @var string
     */
    protected $mime_type = '';

    /**
     * ユーザーID
     * @var integer
     */
    protected $uid = 0;

    /**
     * グループID
     * @var integer
     */
    protected $gid = 0;

    /**
     * サイズ
     * @var integer
     */
    protected $size = 0;

    /**
     * バイナリデータ
     * @var binary
     */
    protected $buffer = null;

    /**
     * MIMEタイプの設定
     *
     * @access public
     * @param string $mime_type
     * @return void
     */
    public function setMimeType($mime_type)
    {
        $this->mime_type = $mime_type;
    }

    /**
     * ユーザーIDの設定
     *
     * @access public
     * @param integer $uid
     * @return void
     */
    public function setUID($uid)
    {
        $this->uid = $uid;
    }

    /**
     * グループIDの設定
     *
     * @access public
     * @param integer $gid
     * @return void
     */
    public function setGID($gid)
    {
        $this->gid = $gid;
    }

    /**
     * サイズの設定
     *
     * @access public
     * @param integer $size
     * @return void
     */
    public function setSize($size)
    {
        $this->size = $size;
    }

    /**
     * バッファーの設定
     *
     * @access public
     * @param binary $buffer
     * @return void
     */
    public function setBuffer($buffer)
    {
        $this->buffer = $buffer;
        $this->size = strlen($this->buffer);
    }

    /**
     * ファイル名の取得
     *
     * @access public
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * MIMEタイプの取得
     *
     * @access public
     * @return string
     */
    public function getMimeType()
    {
        return $this->mime_type;
    }

    /**
     * 所持バッファーの取得
     *
     * @access public
     * @return binary
     */
    public function getBuffer()
    {
        return $this->buffer;
    }

    /**
     * 拡張子の取得
     *
     * @access public
     * @return string 拡張子
     */
    public function getExtension($name=null)
    {
        $name = empty($name)? $this->name:$name;
        $pos = strrpos($name, '.');
        if (!$pos){
            return '';
        }
        $extension = substr($name, $pos+1);

        return strtolower($extension);
    }

    /**
     * MIME-TYPEの取得
     *
     * @access public
     * @param string $name
     * @return string mime-type
     */
    public function _getMimeType($name)
    {
        $pos = strrpos($name, '.');
        if (!$pos){
            return '';
        }
        $extension = substr($name, $pos+1);
        $extension = strtolower($extension);
    
        $mime_types = array(
            'zip' => 'application/zip',
            'gz'  => 'application/x-gzip',
            'pdf' => 'application/pdf',
            'js'  => 'application/x-javascript',
            'jpeg'=> 'image/jpeg',
            'jpg' => 'image/jpeg',
            'png' => 'image/png',
            'gif' => 'image/gif',
            'html'=> 'text/html',
            'htm' => 'text/html',
            'xml' => 'text/xml',
            'css' => 'text/css',
            'txt' => 'text/plain',
            'tmp' => 'empty',
        );
        return empty($mime_types[$extension])? 'text/html':$mime_types[$extension];
    }

    /**
     * ファイルをバッファに格納
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    public function readfile($filename)
    {
        if (!file_exists ($filename)){
            return false;
        }
        $this->name      = basename($filename);
        $this->size      = filesize($filename);
        $this->mime_type = $this->_getMimeType($filename);

        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'rb');
        if (!is_resource($handle)) {
            return false;
        }
        $this->buffer = fread($handle, $this->size);
        fclose($handle);
        
        return true;
    }

    /**
     * 対象データの出力
     *
     * @access public
     * @param boolean $inline
     * @return void
     */
    public function output($inline=true)
    {
        if ($inline){
            header('Content-Type: '.$this->mime_type);
            header('Content-Length: '.$this->size);
            header('Content-disposition: inline; filename='.$this->name);
        } else {
            header('Content-Type: application/force-download');
            header('Content-Length: '.$this->size);
            header('Content-disposition: attachment; filename='.$this->name);
        }
        print ($this->buffer);
    }
} // BLOB_Commonの終了
?>